/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;

public class Point
extends AbstractGjsonObject {
    private BigDecimal lat;
    private BigDecimal lon;

    public Point(BigDecimal lat, BigDecimal lon, JSONObject crs) {
        this();
        this.lat = lat;
        this.lon = lon;
        this.crs = crs;
    }

    public Point(BigDecimal lat, BigDecimal lon) {
        this(lat, lon, null);
    }

    public Point(Builder builder) {
        this(builder.lat, builder.lon, builder.crs);
    }

    public Point(Double lat, Double lon) {
        this(BigDecimal.valueOf(lat), BigDecimal.valueOf(lon));
    }

    public Point() {
        super(GjsonObjectType.Point);
    }

    public static final Point of(String geojson) {
        Point p = new Point();
        p = p.decode(geojson);
        return p;
    }

    public static final Point of(BigDecimal lat, BigDecimal lon) {
        return new Point(lat, lon);
    }

    public static final Point of(Double lat, Double lon) {
        return new Point(lat, lon);
    }

    public static final Point newInstance() {
        return new Point();
    }

    @Override
    public Point decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.Point);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        JSONArray arr = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        BigDecimal _lon = arr.getBigDecimal(0);
        BigDecimal _lat = arr.getBigDecimal(1);
        this.setLat(_lat);
        this.setLon(_lon);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = this.handle();
        geometry.put(GjsonMember.COORDINATES.toString(), new BigDecimal[]{this.lon, this.lat});
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        final Point that = this;
        return new Enumeration<Point>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < 1;
            }

            @Override
            public Point nextElement() {
                if (this.hasMoreElements()) {
                    ++this.index;
                    return that;
                }
                throw new NoSuchElementException("There is no more element.");
            }
        };
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.Point) || !this.isCrsValid()) {
            return false;
        }
        return this.lat != null && this.lon != null;
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.Point);
        if (this.lat == null || this.lon == null) {
            throw new GjsonEncodeException(this);
        }
    }

    public void setLat(Double lat) {
        this.lat = BigDecimal.valueOf(lat);
    }

    public BigDecimal getLat() {
        return this.lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public BigDecimal getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = BigDecimal.valueOf(lon);
    }

    public void setLon(BigDecimal lon) {
        this.lon = lon;
    }

    public static class Builder {
        public BigDecimal lat;
        public BigDecimal lon;
        public JSONObject crs;

        public Builder setLat(BigDecimal lat) {
            this.lat = lat;
            return this;
        }

        public Builder setLon(BigDecimal lon) {
            this.lon = lon;
            return this;
        }

        public Builder setLat(Double lat) {
            this.lat = BigDecimal.valueOf(lat);
            return this;
        }

        public Builder setLon(Double lon) {
            this.lon = BigDecimal.valueOf(lon);
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public Point build() {
            return new Point(this);
        }
    }
}

