/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.Point;
import terrageo.gjson.Polygon;

public class MultiPolygon
extends AbstractGjsonObject
implements Iterable<Polygon> {
    private List<Polygon> coordinates;

    public MultiPolygon(List<Polygon> coordinates, JSONObject crs) {
        this();
        this.coordinates = coordinates;
        this.crs = crs;
    }

    public MultiPolygon(List<Polygon> polygons) {
        this(polygons, null);
    }

    public MultiPolygon(Builder builder) {
        this(builder.coordinates, builder.crs);
    }

    public MultiPolygon(Polygon ... polygons) {
        this(Arrays.asList(polygons));
    }

    public MultiPolygon() {
        super(GjsonObjectType.MultiPolygon);
    }

    public static final MultiPolygon of(String geojson) {
        MultiPolygon mp = new MultiPolygon();
        mp = mp.decode(geojson);
        return mp;
    }

    public static final MultiPolygon of(List<Polygon> list) {
        return new MultiPolygon(list);
    }

    public static final MultiPolygon of(Polygon ... polygons) {
        return new MultiPolygon(polygons);
    }

    public static final MultiPolygon newInstance() {
        return new MultiPolygon();
    }

    @Override
    public MultiPolygon decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.MultiPolygon);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        ArrayList<Polygon> ref = new ArrayList<Polygon>();
        JSONArray shell = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        for (int i = 0; i < shell.length(); ++i) {
            JSONArray each = shell.getJSONArray(i);
            Polygon eachPolygon = new Polygon();
            ArrayList<List<Point>> coords = new ArrayList<List<Point>>();
            for (int j = 0; j < each.length(); ++j) {
                JSONArray dimension = each.getJSONArray(j);
                ArrayList<Point> ps = new ArrayList<Point>();
                for (int k = 0; k < dimension.length(); ++k) {
                    JSONArray parr = dimension.getJSONArray(k);
                    BigDecimal lon = parr.getBigDecimal(0);
                    BigDecimal lat = parr.getBigDecimal(1);
                    Point p = new Point(lat, lon);
                    ps.add(p);
                }
                coords.add(ps);
            }
            eachPolygon.setCoordinates(coords);
            ref.add(eachPolygon);
        }
        this.setCoordinates(ref);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = this.handle();
        ArrayList encodedShell = new ArrayList();
        for (Polygon each : this.getCoordinates()) {
            ArrayList encodedEach = new ArrayList();
            for (List<Point> coords : each.getCoordinates()) {
                ArrayList<BigDecimal[]> pairEach = new ArrayList<BigDecimal[]>();
                for (Point next : coords) {
                    BigDecimal lat = next.getLat();
                    BigDecimal lon = next.getLon();
                    BigDecimal[] pArr = new BigDecimal[]{lon, lat};
                    pairEach.add(pArr);
                }
                encodedEach.add(pairEach);
            }
            encodedShell.add(encodedEach);
        }
        geometry.put(GjsonMember.COORDINATES.toString(), encodedShell);
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getCoordinates() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final List<Polygon> ref = this.getCoordinates();
        final int length = this.getCoordinates().size();
        return new Enumeration<Point>(){
            private int dimension = 0;
            private int order = 0;
            private Polygon current = (Polygon)ref.get(this.order);
            private List<List<Point>> pointer = this.current.getCoordinates();
            private Iterator<Point> iterator = this.pointer.get(this.dimension).iterator();
            private int limit = this.pointer.size();

            @Override
            public boolean hasMoreElements() {
                if (this.iterator.hasNext()) {
                    return true;
                }
                if (this.dimension + 1 < this.limit) {
                    ++this.dimension;
                    this.iterator = this.pointer.get(this.dimension).iterator();
                } else if (this.order + 1 < length) {
                    ++this.order;
                    this.current = (Polygon)ref.get(this.order);
                    this.pointer = this.current.getCoordinates();
                    this.iterator = this.pointer.get(this.dimension).iterator();
                    this.limit = this.pointer.size();
                }
                return this.iterator.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public Iterator<Polygon> iterator() {
        if (this.getCoordinates() == null) {
            Collections.emptyList().iterator();
        }
        return this.getCoordinates().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.MultiPolygon) || !this.isCrsValid()) {
            return false;
        }
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            return false;
        }
        for (Polygon next : this.getCoordinates()) {
            if (next.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.MultiPolygon);
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
        for (Polygon next : this.getCoordinates()) {
            if (next.isValid()) continue;
            throw new GjsonEncodeException(next);
        }
    }

    public List<Polygon> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Polygon> coordinates) {
        this.coordinates = coordinates;
    }

    public static class Builder {
        public List<Polygon> coordinates = new ArrayList<Polygon>();
        public JSONObject crs;

        public Builder put(Polygon polygon) {
            this.coordinates.add(polygon);
            return this;
        }

        public Builder setCoordinates(List<Polygon> polygons) {
            this.coordinates = polygons;
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public MultiPolygon build() {
            return new MultiPolygon(this);
        }
    }
}

