/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.Point;

public class MultiPoint
extends AbstractGjsonObject
implements Iterable<Point> {
    private List<Point> coordinates;

    public MultiPoint(List<Point> coordinates, JSONObject crs) {
        this();
        this.coordinates = coordinates;
        this.crs = crs;
    }

    public MultiPoint(List<Point> coordinates) {
        this(coordinates, null);
    }

    public MultiPoint(Builder builder) {
        this(builder.coordinates, builder.crs);
    }

    public MultiPoint(Point ... coordinates) {
        this(Arrays.asList(coordinates));
    }

    public MultiPoint() {
        super(GjsonObjectType.MultiPoint);
    }

    public static final MultiPoint of(String geojson) {
        MultiPoint mp = new MultiPoint();
        mp = mp.decode(geojson);
        return mp;
    }

    public static final MultiPoint of(List<Point> coordinates) {
        return new MultiPoint(coordinates);
    }

    public static final MultiPoint of(Point ... points) {
        return new MultiPoint(points);
    }

    public static final MultiPoint newInstance() {
        return new MultiPoint();
    }

    @Override
    public MultiPoint decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.MultiPoint);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        ArrayList<Point> ref = new ArrayList<Point>();
        JSONArray arr = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        for (int i = 0; i < arr.length(); ++i) {
            JSONArray tmp = arr.getJSONArray(i);
            BigDecimal lon = tmp.getBigDecimal(0);
            BigDecimal lat = tmp.getBigDecimal(1);
            Point p = new Point(lat, lon);
            ref.add(p);
        }
        this.setCoordinates(ref);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = this.handle();
        ArrayList<BigDecimal[]> list = new ArrayList<BigDecimal[]>();
        for (Point next : this.getCoordinates()) {
            BigDecimal lat = next.getLat();
            BigDecimal lon = next.getLon();
            BigDecimal[] p = new BigDecimal[]{lon, lat};
            list.add(p);
        }
        geometry.put(GjsonMember.COORDINATES.toString(), list);
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getCoordinates() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final List<Point> ref = this.getCoordinates();
        return new Enumeration<Point>(){
            private final Iterator<Point> iterator;
            {
                this.iterator = ref.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public Iterator<Point> iterator() {
        if (this.getCoordinates() == null) {
            Collections.emptyList().iterator();
        }
        return this.getCoordinates().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.MultiPoint) || !this.isCrsValid()) {
            return false;
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            return false;
        }
        for (Point next : this.coordinates) {
            if (next.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.MultiPoint);
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new GjsonEncodeException(this);
        }
        for (Point next : this.coordinates) {
            if (next.isValid()) continue;
            throw new GjsonEncodeException(next);
        }
    }

    public List<Point> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Point> coordinates) {
        this.coordinates = coordinates;
    }

    public static class Builder {
        public List<Point> coordinates = new ArrayList<Point>();
        public JSONObject crs;

        public Builder put(Point point) {
            this.coordinates.add(point);
            return this;
        }

        public Builder setCoordinates(List<Point> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public MultiPoint build() {
            return new MultiPoint(this);
        }
    }
}

