/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.LineString;
import terrageo.gjson.Point;

public class MultiLineString
extends AbstractGjsonObject
implements Iterable<LineString> {
    private List<LineString> coordinates;

    public MultiLineString(List<LineString> coordinates, JSONObject crs) {
        this();
        this.coordinates = coordinates;
        this.crs = crs;
    }

    public MultiLineString(List<LineString> lineStrings) {
        this(lineStrings, null);
    }

    public MultiLineString(Builder builder) {
        this(builder.coordinates, builder.crs);
    }

    public MultiLineString(LineString ... strings) {
        this(Arrays.asList(strings));
    }

    public MultiLineString() {
        super(GjsonObjectType.MultiLineString);
    }

    public static final MultiLineString of(String geojson) {
        MultiLineString mls = new MultiLineString();
        mls = mls.decode(geojson);
        return mls;
    }

    public static final MultiLineString of(List<LineString> list) {
        return new MultiLineString(list);
    }

    public static final MultiLineString of(LineString ... lineStrings) {
        return new MultiLineString(lineStrings);
    }

    public static final MultiLineString newInstance() {
        return new MultiLineString();
    }

    @Override
    public MultiLineString decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.MultiLineString);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        ArrayList<LineString> stack = new ArrayList<LineString>();
        JSONArray shell = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        for (int i = 0; i < shell.length(); ++i) {
            JSONArray inner = shell.getJSONArray(i);
            ArrayList<Point> elem = new ArrayList<Point>();
            for (int j = 0; j < inner.length(); ++j) {
                JSONArray each = inner.getJSONArray(j);
                BigDecimal lon = each.getBigDecimal(0);
                BigDecimal lat = each.getBigDecimal(1);
                Point p = new Point(lat, lon);
                elem.add(p);
            }
            stack.add(new LineString(elem));
        }
        this.setCoordinates(stack);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = this.handle();
        List<LineString> ref = this.getCoordinates();
        ArrayList stack = new ArrayList();
        for (LineString current : ref) {
            ArrayList<BigDecimal[]> elem = new ArrayList<BigDecimal[]>();
            for (Point dot : current.getCoordinates()) {
                BigDecimal lat = dot.getLat();
                BigDecimal lon = dot.getLon();
                elem.add(new BigDecimal[]{lon, lat});
            }
            stack.add(elem);
        }
        geometry.put(GjsonMember.COORDINATES.toString(), stack);
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getCoordinates() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final List<LineString> ref = this.getCoordinates();
        final int length = ref.size();
        return new Enumeration<Point>(){
            private int index = 0;
            private LineString ls = (LineString)ref.get(this.index);
            private Iterator<Point> it = this.ls.getCoordinates().iterator();

            @Override
            public boolean hasMoreElements() {
                if (this.it.hasNext()) {
                    return true;
                }
                if (this.index + 1 < length) {
                    ++this.index;
                    this.ls = (LineString)ref.get(this.index);
                    this.it = this.ls.getCoordinates().iterator();
                }
                return this.it.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public Iterator<LineString> iterator() {
        if (this.getCoordinates() == null) {
            Collections.emptyList().iterator();
        }
        return this.getCoordinates().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.MultiLineString) || !this.isCrsValid()) {
            return false;
        }
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            return false;
        }
        for (LineString next : this.getCoordinates()) {
            if (next.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.MultiLineString);
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
        for (LineString next : this.getCoordinates()) {
            if (next.isValid()) continue;
            throw new GjsonEncodeException(next);
        }
    }

    public List<LineString> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<LineString> coordinates) {
        this.coordinates = coordinates;
    }

    public static class Builder {
        public List<LineString> coordinates = new ArrayList<LineString>();
        public JSONObject crs;

        public Builder put(LineString ls) {
            this.coordinates.add(ls);
            return this;
        }

        public Builder setCoordinates(List<LineString> lineStrings) {
            this.coordinates = lineStrings;
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public MultiLineString build() {
            return new MultiLineString(this);
        }
    }
}

