/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.Point;

public class LineString
extends AbstractGjsonObject
implements Iterable<Point> {
    private List<Point> coordinates;

    public LineString(List<Point> coordinates, JSONObject crs) {
        this();
        this.coordinates = coordinates;
        this.crs = crs;
    }

    public LineString(List<Point> coordinates) {
        this(coordinates, null);
    }

    public LineString(Builder builder) {
        this(builder.coordinates, builder.crs);
    }

    public LineString(Point ... points) {
        this(Arrays.asList(points));
    }

    public LineString() {
        super(GjsonObjectType.LineString);
    }

    public static final LineString of(String geojson) {
        LineString l = new LineString();
        l = l.decode(geojson);
        return l;
    }

    public static final LineString of(List<Point> coordinates) {
        return new LineString(coordinates);
    }

    public static final LineString of(Point ... points) {
        return new LineString(points);
    }

    public static final LineString newInstance() {
        return new LineString();
    }

    @Override
    public LineString decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.LineString);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        JSONArray shell = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        ArrayList<Point> ref = new ArrayList<Point>();
        for (int i = 0; i < shell.length(); ++i) {
            JSONArray next = shell.getJSONArray(i);
            BigDecimal lon = next.getBigDecimal(0);
            BigDecimal lat = next.getBigDecimal(1);
            Point p = new Point(lat, lon);
            ref.add(p);
        }
        this.setCoordinates(ref);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = this.handle();
        ArrayList<BigDecimal[]> c = new ArrayList<BigDecimal[]>();
        for (Point next : this.getCoordinates()) {
            BigDecimal lat = next.getLat();
            BigDecimal lon = next.getLon();
            BigDecimal[] bd = new BigDecimal[]{lon, lat};
            c.add(bd);
        }
        geometry.put(GjsonMember.COORDINATES.toString(), c);
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getCoordinates() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final List<Point> ref = this.getCoordinates();
        return new Enumeration<Point>(){
            final Iterator<Point> it;
            {
                this.it = ref.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public Iterator<Point> iterator() {
        if (this.getCoordinates() == null) {
            Collections.emptyList().iterator();
        }
        return this.getCoordinates().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.LineString) || !this.isCrsValid()) {
            return false;
        }
        return this.getCoordinates() != null && !this.getCoordinates().isEmpty();
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.LineString);
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
    }

    public void setCoordinates(List<Point> coordinates) {
        this.coordinates = coordinates;
    }

    public List<Point> getCoordinates() {
        return this.coordinates;
    }

    public static class Builder {
        public List<Point> coordinates = new ArrayList<Point>();
        public JSONObject crs;

        public Builder put(Point point) {
            this.coordinates.add(point);
            return this;
        }

        public Builder setCoordinates(List<Point> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public LineString build() {
            return new LineString(this);
        }
    }
}

