/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.Feature;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.Point;

public class FeatureCollection
extends AbstractGjsonObject
implements Iterable<Feature> {
    private List<Feature> features;

    public FeatureCollection(List<Feature> features, JSONObject crs) {
        this();
        this.features = features;
        this.crs = crs;
    }

    public FeatureCollection(List<Feature> features) {
        this(features, null);
    }

    public FeatureCollection(Builder builder) {
        this(builder.features, builder.crs);
    }

    public FeatureCollection(Feature ... features) {
        this(Arrays.asList(features));
    }

    public FeatureCollection() {
        super(GjsonObjectType.FeatureCollection);
    }

    public static final FeatureCollection of(String geojson) {
        FeatureCollection fc = new FeatureCollection();
        fc = fc.decode(geojson);
        return fc;
    }

    public static final FeatureCollection of(List<Feature> features) {
        return new FeatureCollection(features);
    }

    public static final FeatureCollection of(Feature ... features) {
        return new FeatureCollection(features);
    }

    public static final FeatureCollection newInstance() {
        return new FeatureCollection();
    }

    @Override
    public FeatureCollection decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.FeatureCollection);
        if (!gjson.has(GjsonMember.FEATURES.toString())) {
            throw new GjsonDecodeException("An object of type 'FeatureCollection' must have a member with the name 'features'.");
        }
        JSONArray arr = gjson.getJSONArray(GjsonMember.FEATURES.toString());
        ArrayList<Feature> ref = new ArrayList<Feature>();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject tmp = arr.getJSONObject(i);
            String json = tmp.toString();
            Feature f = Feature.of(json);
            ref.add(f);
        }
        this.setFeatures(ref);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject obj = this.handle();
        JSONArray fs = new JSONArray();
        for (Feature next : this.getFeatures()) {
            fs.put(next.encode());
        }
        obj.put(GjsonMember.FEATURES.toString(), fs);
        return obj;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getFeatures() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final ArrayList<Point> collector = new ArrayList<Point>();
        for (Feature next : this.getFeatures()) {
            Enumeration<Point> en = next.enumeration();
            while (en.hasMoreElements()) {
                collector.add(en.nextElement());
            }
        }
        return new Enumeration<Point>(){
            final Iterator<Point> iterator;
            {
                this.iterator = collector.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public Iterator<Feature> iterator() {
        if (this.getFeatures() == null) {
            Collections.emptyList().iterator();
        }
        return this.getFeatures().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.FeatureCollection) || !this.isCrsValid()) {
            return false;
        }
        return this.getFeatures() != null && !this.getFeatures().isEmpty();
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.FeatureCollection);
        if (this.getFeatures() == null || this.getFeatures().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public static class Builder {
        public List<Feature> features = new ArrayList<Feature>();
        public JSONObject crs;

        public Builder put(Feature f) {
            this.features.add(f);
            return this;
        }

        public Builder setFeatures(List<Feature> features) {
            this.features = features;
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public FeatureCollection build() {
            return new FeatureCollection(this);
        }
    }
}

