/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import terrageo.gjson.AbstractGjsonObject;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONObject;
import terrageo.gjson.LineString;
import terrageo.gjson.MultiLineString;
import terrageo.gjson.MultiPoint;
import terrageo.gjson.MultiPolygon;
import terrageo.gjson.Point;
import terrageo.gjson.Polygon;

public class Feature
extends AbstractGjsonObject {
    private JSONObject properties = new JSONObject();
    private GjsonObject geometry;
    private String id;

    public Feature(GjsonObject geometry, JSONObject crs, String id) {
        this();
        this.geometry = geometry;
        this.crs = crs;
        this.id = id;
    }

    public Feature(GjsonObject geometry) {
        this(geometry, null, null);
    }

    public Feature(Builder builder) {
        this(builder.geometry, builder.crs, builder.id);
        this.properties = builder.properties;
    }

    public Feature() {
        super(GjsonObjectType.Feature);
    }

    public static final Feature of(String geojson) {
        Feature f = new Feature();
        f = f.decode(geojson);
        return f;
    }

    public static final Feature of(GjsonObject object) {
        return new Feature(object);
    }

    @Override
    public Feature decode(String geojson) {
        JSONObject gjson = this.handle(geojson, GjsonObjectType.Feature);
        if (gjson.has(GjsonMember.ID.toString())) {
            this.setId(gjson.getString(GjsonMember.ID.toString()));
        }
        if (!gjson.has(GjsonMember.PROPERTIES.toString())) {
            this.setProperties(new JSONObject());
        } else {
            this.setProperties(gjson.getJSONObject(GjsonMember.PROPERTIES.toString()));
        }
        if (!gjson.has(GjsonMember.GEOMETRY.toString())) {
            throw new GjsonDecodeException("Feature object must have a member with the name 'geoemtry'.");
        }
        JSONObject geom = gjson.getJSONObject(GjsonMember.GEOMETRY.toString());
        String json = geom.toString();
        if (!geom.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("geometry has no type property.");
        }
        String objectType = geom.getString(GjsonMember.TYPE.toString());
        if (GjsonObjectType.isPoint(objectType)) {
            this.setGeometry(Point.of(json));
        } else if (GjsonObjectType.isLineString(objectType)) {
            this.setGeometry(LineString.of(json));
        } else if (GjsonObjectType.isPolygon(objectType)) {
            this.setGeometry(Polygon.of(json));
        } else if (GjsonObjectType.isMultiPoint(objectType)) {
            this.setGeometry(MultiPoint.of(json));
        } else if (GjsonObjectType.isMultiLineString(objectType)) {
            this.setGeometry(MultiLineString.of(json));
        } else if (GjsonObjectType.isMultiPolygon(objectType)) {
            this.setGeometry(MultiPolygon.of(json));
        }
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject feature = this.handle();
        feature.put(GjsonMember.PROPERTIES.toString(), this.getProperties());
        if (this.getId() != null && !this.getId().isEmpty()) {
            feature.put(GjsonMember.ID.toString(), this.getId());
        }
        feature.put(GjsonMember.GEOMETRY.toString(), this.getGeometry().encode());
        return feature;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getGeometry() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        return this.getGeometry().enumeration();
    }

    @Override
    public boolean isValid() {
        if (!this.isTypeValid(GjsonObjectType.Feature) || !this.isCrsValid()) {
            return false;
        }
        if (this.getProperties() == null) {
            return false;
        }
        return this.getGeometry() != null && this.getGeometry().isValid();
    }

    @Override
    public void validation() throws GjsonEncodeException {
        this.validator(GjsonObjectType.Feature);
        if (this.getGeometry() == null || !this.getGeometry().isValid()) {
            throw new GjsonEncodeException(this.getGeometry());
        }
        if (this.getProperties() == null) {
            throw new GjsonEncodeException(this.getGeometry());
        }
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public void setProperties(JSONObject properties) {
        this.properties = properties;
    }

    public GjsonObject getGeometry() {
        return this.geometry;
    }

    public void setGeometry(GjsonObject geometry) {
        this.geometry = geometry;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class Builder {
        public JSONObject properties = new JSONObject();
        public GjsonObject geometry;
        public JSONObject crs;
        public String id;

        public Builder setProperties(JSONObject properties) {
            this.properties = properties;
            return this;
        }

        public Builder setGeometry(GjsonObject geometry) {
            this.geometry = geometry;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCrs(JSONObject crs) {
            this.crs = crs;
            return this;
        }

        public Feature build() {
            return new Feature(this);
        }
    }
}

