/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import terrageo.gjson.Gjson;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONObject;

public abstract class AbstractGjsonObject
implements GjsonObject {
    protected GjsonObjectType type;
    protected JSONObject crs;

    protected AbstractGjsonObject(GjsonObjectType type) {
        this.type = type;
    }

    protected void handleType(JSONObject gjson, GjsonObjectType objectType) {
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String t = gjson.getString(GjsonMember.TYPE.toString());
        if (!GjsonObjectType.is(t, objectType)) {
            throw new GjsonDecodeException("Invalid Type.");
        }
        this.setType(objectType);
    }

    protected void handleCrs(JSONObject gjson) {
        if (Gjson.crsValidation(gjson)) {
            this.setCrs(gjson.getJSONObject(GjsonMember.CRS.toString()));
        }
    }

    protected JSONObject handle(String geojson, GjsonObjectType objectType) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        this.handleType(gjson, objectType);
        this.handleCrs(gjson);
        return gjson;
    }

    protected JSONObject handle() {
        this.validation();
        JSONObject geometry = new JSONObject();
        geometry.put(GjsonMember.TYPE.toString(), this.getType().toString());
        if (this.getCrs() != null) {
            geometry.put(GjsonMember.CRS.toString(), this.getCrs());
        }
        return geometry;
    }

    protected boolean isCrsValid() {
        return this.getCrs() == null || Gjson.crsValidation(this.getCrs());
    }

    protected boolean isTypeValid(GjsonObjectType objectType) {
        return this.getType() != null && this.getType().equals((Object)objectType);
    }

    protected void validator(GjsonObjectType objectType) {
        if (!this.isTypeValid(objectType)) {
            throw new GjsonEncodeException(this);
        }
        if (!this.isCrsValid()) {
            throw new GjsonEncodeException(this);
        }
    }

    @Override
    public void setType(GjsonObjectType type) {
        this.type = type;
    }

    @Override
    public GjsonObjectType getType() {
        return this.type;
    }

    @Override
    public JSONObject getCrs() {
        return this.crs;
    }

    @Override
    public void setCrs(JSONObject crs) {
        this.crs = crs;
    }

    @Override
    public String toString(int indent) {
        return this.encode().toString(indent);
    }

    @Override
    public String toString() {
        return this.encode().toString();
    }
}

