/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.Gjson;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.Point;

public class Polygon
implements GjsonObject,
Iterable<Point> {
    private GjsonObjectType type = GjsonObjectType.Polygon;
    private List<List<Point>> coordinates;

    public Polygon(List<List<Point>> coordinates) {
        this.coordinates = coordinates;
    }

    public Polygon(Builder builder) {
        this(builder.coordinates);
    }

    public Polygon() {
    }

    public static final Polygon of(String geojson) {
        Polygon p = new Polygon();
        p.decode(geojson);
        return p;
    }

    public static final Polygon of(List<List<Point>> points) {
        return new Polygon(points);
    }

    public static final Polygon from(List<Point> points) {
        ArrayList<List<Point>> c = new ArrayList<List<Point>>();
        c.add(points);
        return new Polygon(c);
    }

    public static final Polygon of(Point ... points) {
        ArrayList<List<Point>> c = new ArrayList<List<Point>>();
        c.add(Arrays.asList(points));
        return new Polygon(c);
    }

    public static final Polygon newInstance() {
        return new Polygon();
    }

    @Override
    public Polygon decode(String geojson) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String t = gjson.getString(GjsonMember.TYPE.toString());
        if (!GjsonObjectType.isPolygon(t)) {
            throw new GjsonDecodeException("Invalid Type.");
        }
        this.setType(GjsonObjectType.Polygon);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        ArrayList<List<Point>> stack = new ArrayList<List<Point>>();
        JSONArray arr = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        for (int i = 0; i < arr.length(); ++i) {
            JSONArray tmp = arr.getJSONArray(i);
            ArrayList<Point> sublist = new ArrayList<Point>();
            for (int j = 0; j < tmp.length(); ++j) {
                JSONArray p = tmp.getJSONArray(j);
                BigDecimal plon = p.getBigDecimal(0);
                BigDecimal plat = p.getBigDecimal(1);
                Point next = new Point(plat, plon);
                sublist.add(next);
            }
            stack.add(sublist);
        }
        this.setCoordinates(stack);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = new JSONObject();
        geometry.put(GjsonMember.TYPE.toString(), this.getType().toString());
        List<List<Point>> list = this.getCoordinates();
        ArrayList encoded = new ArrayList();
        for (List<Point> sublist : list) {
            ArrayList<BigDecimal[]> pairlist = new ArrayList<BigDecimal[]>();
            for (Point next : sublist) {
                BigDecimal lat = next.getLat();
                BigDecimal lon = next.getLon();
                BigDecimal[] pair = new BigDecimal[]{lon, lat};
                pairlist.add(pair);
            }
            encoded.add(pairlist);
        }
        geometry.put(GjsonMember.COORDINATES.toString(), encoded);
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getCoordinates() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final List<List<Point>> ref = this.getCoordinates();
        final int length = this.getCoordinates().size();
        return new Enumeration<Point>(){
            private int dimension = 0;
            private Iterator<Point> iterator = ((List)ref.get(this.dimension)).iterator();

            @Override
            public boolean hasMoreElements() {
                if (this.iterator.hasNext()) {
                    return true;
                }
                if (this.dimension + 1 < length) {
                    ++this.dimension;
                    this.iterator = ((List)ref.get(this.dimension)).iterator();
                }
                return this.iterator.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public Iterator<Point> iterator() {
        if (this.getCoordinates() == null) {
            Collections.emptyList().iterator();
        } else if (this.getCoordinates().size() == 1) {
            return this.getCoordinates().get(0).iterator();
        }
        ArrayList<Point> stack = new ArrayList<Point>();
        for (List<Point> shell : this.getCoordinates()) {
            for (Point each : shell) {
                stack.add(each);
            }
        }
        return stack.iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.type.equals((Object)GjsonObjectType.Polygon)) {
            return false;
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            return false;
        }
        for (List<Point> list : this.coordinates) {
            for (Point next : list) {
                if (next.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void validation() throws GjsonEncodeException {
        if (!this.type.equals((Object)GjsonObjectType.Polygon)) {
            throw new GjsonEncodeException(this);
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new GjsonEncodeException(this);
        }
        for (List<Point> list : this.coordinates) {
            for (Point next : list) {
                if (next.isValid()) continue;
                throw new GjsonEncodeException(next);
            }
        }
    }

    @Override
    public String toString() {
        return this.encode().toString();
    }

    @Override
    public String toString(int offset) {
        return this.encode().toString(offset);
    }

    @Override
    public GjsonObjectType getType() {
        return this.type;
    }

    @Override
    public void setType(GjsonObjectType type) {
        this.type = type;
    }

    public List<List<Point>> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<List<Point>> coordinates) {
        this.coordinates = coordinates;
    }

    public static class Builder {
        public List<List<Point>> coordinates = new ArrayList<List<Point>>();

        public Builder put(List<Point> list) {
            this.coordinates.add(list);
            return this;
        }

        public Builder setCoordinates(List<List<Point>> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Polygon build() {
            return new Polygon(this);
        }
    }
}

