/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.Gjson;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.LineString;
import terrageo.gjson.Point;

public class MultiLineString
implements GjsonObject,
Iterable<LineString> {
    private GjsonObjectType type = GjsonObjectType.MultiLineString;
    private List<LineString> coordinates;

    public MultiLineString(List<LineString> lineStrings) {
        this.coordinates = lineStrings;
    }

    public MultiLineString(Builder builder) {
        this(builder.coordinates);
    }

    public MultiLineString(LineString ... strings) {
        this(Arrays.asList(strings));
    }

    public MultiLineString() {
    }

    public static final MultiLineString of(String geojson) {
        MultiLineString mls = new MultiLineString();
        mls = mls.decode(geojson);
        return mls;
    }

    public static final MultiLineString of(List<LineString> list) {
        return new MultiLineString(list);
    }

    public static final MultiLineString of(LineString ... lineStrings) {
        return new MultiLineString(lineStrings);
    }

    public static final MultiLineString newInstance() {
        return new MultiLineString();
    }

    @Override
    public MultiLineString decode(String geojson) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String t = gjson.getString(GjsonMember.TYPE.toString());
        if (!GjsonObjectType.isMultiLineString(t)) {
            throw new GjsonDecodeException("Invalid Type.");
        }
        this.setType(GjsonObjectType.MultiLineString);
        if (!gjson.has(GjsonMember.COORDINATES.toString())) {
            throw new GjsonDecodeException("JSON has no coordinates property.");
        }
        ArrayList<LineString> stack = new ArrayList<LineString>();
        JSONArray shell = gjson.getJSONArray(GjsonMember.COORDINATES.toString());
        for (int i = 0; i < shell.length(); ++i) {
            JSONArray inner = shell.getJSONArray(i);
            ArrayList<Point> elem = new ArrayList<Point>();
            for (int j = 0; j < inner.length(); ++j) {
                JSONArray each = inner.getJSONArray(j);
                BigDecimal lon = each.getBigDecimal(0);
                BigDecimal lat = each.getBigDecimal(1);
                Point p = new Point(lat, lon);
                elem.add(p);
            }
            stack.add(new LineString(elem));
        }
        this.setCoordinates(stack);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometry = new JSONObject();
        geometry.put(GjsonMember.TYPE.toString(), this.getType().toString());
        List<LineString> ref = this.getCoordinates();
        ArrayList stack = new ArrayList();
        for (LineString current : ref) {
            ArrayList<BigDecimal[]> elem = new ArrayList<BigDecimal[]>();
            for (Point dot : current.getCoordinates()) {
                BigDecimal lat = dot.getLat();
                BigDecimal lon = dot.getLon();
                elem.add(new BigDecimal[]{lon, lat});
            }
            stack.add(elem);
        }
        geometry.put(GjsonMember.COORDINATES.toString(), stack);
        return geometry;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getCoordinates() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final List<LineString> ref = this.getCoordinates();
        final int length = ref.size();
        return new Enumeration<Point>(){
            private int index = 0;
            private LineString ls = (LineString)ref.get(this.index);
            private Iterator<Point> it = this.ls.getCoordinates().iterator();

            @Override
            public boolean hasMoreElements() {
                if (this.it.hasNext()) {
                    return true;
                }
                if (this.index + 1 < length) {
                    ++this.index;
                    this.ls = (LineString)ref.get(this.index);
                    this.it = this.ls.getCoordinates().iterator();
                }
                return this.it.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public Iterator<LineString> iterator() {
        if (this.getCoordinates() == null) {
            Collections.emptyList().iterator();
        }
        return this.getCoordinates().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.type.equals((Object)GjsonObjectType.MultiLineString)) {
            return false;
        }
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            return false;
        }
        for (LineString next : this.getCoordinates()) {
            if (next.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validation() throws GjsonEncodeException {
        if (!this.type.equals((Object)GjsonObjectType.MultiLineString)) {
            throw new GjsonEncodeException(this);
        }
        if (this.getCoordinates() == null || this.getCoordinates().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
        for (LineString next : this.getCoordinates()) {
            if (next.isValid()) continue;
            throw new GjsonEncodeException(next);
        }
    }

    @Override
    public String toString(int indent) {
        return this.encode().toString(indent);
    }

    @Override
    public String toString() {
        return this.encode().toString();
    }

    @Override
    public GjsonObjectType getType() {
        return this.type;
    }

    @Override
    public void setType(GjsonObjectType type) {
        this.type = type;
    }

    public List<LineString> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<LineString> coordinates) {
        this.coordinates = coordinates;
    }

    public static class Builder {
        public List<LineString> coordinates = new ArrayList<LineString>();

        public Builder put(LineString ls) {
            this.coordinates.add(ls);
            return this;
        }

        public Builder setCoordinates(List<LineString> lineStrings) {
            this.coordinates = lineStrings;
            return this;
        }

        public MultiLineString build() {
            return new MultiLineString(this);
        }
    }
}

