/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

public enum GjsonObjectType {
    FeatureCollection,
    Feature,
    Point,
    MultiPoint,
    LineString,
    MultiLineString,
    Polygon,
    MultiPolygon,
    GeometryCollection;


    public static final GjsonObjectType typeOf(String typeName) {
        for (GjsonObjectType next : GjsonObjectType.values()) {
            if (!next.toString().equals(typeName)) continue;
            return next;
        }
        return null;
    }

    public static final boolean is(String typeName, GjsonObjectType objectType) {
        return GjsonObjectType.typeOf(typeName).equals((Object)objectType);
    }

    public static final boolean isPoint(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)Point);
    }

    public static final boolean isLineString(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)LineString);
    }

    public static final boolean isPolygon(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)Polygon);
    }

    public static final boolean isMultiPoint(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)MultiPoint);
    }

    public static final boolean isMultiLineString(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)MultiLineString);
    }

    public static final boolean isMultiPolygon(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)MultiPolygon);
    }

    public static final boolean isFeature(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)Feature);
    }

    public static final boolean isFeatureCollection(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)FeatureCollection);
    }

    public static final boolean isGeometryCollection(String typeName) {
        return GjsonObjectType.typeOf(typeName).equals((Object)GeometryCollection);
    }
}

