/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import terrageo.gjson.Feature;
import terrageo.gjson.FeatureCollection;
import terrageo.gjson.GeometryCollection;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONException;
import terrageo.gjson.JSONObject;
import terrageo.gjson.LineString;
import terrageo.gjson.MultiLineString;
import terrageo.gjson.MultiPoint;
import terrageo.gjson.MultiPolygon;
import terrageo.gjson.Point;
import terrageo.gjson.Polygon;

public final class Gjson {
    private Gjson() {
    }

    public static boolean isJSONValid(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e0) {
            try {
                new JSONArray(json);
            }
            catch (JSONException e1) {
                return false;
            }
        }
        return true;
    }

    public static GjsonObject parse(String geojson) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String type = gjson.getString(GjsonMember.TYPE.toString());
        if (GjsonObjectType.isPoint(type)) {
            return Point.of(geojson);
        }
        if (GjsonObjectType.isLineString(type)) {
            return LineString.of(geojson);
        }
        if (GjsonObjectType.isPolygon(type)) {
            return Polygon.of(geojson);
        }
        if (GjsonObjectType.isMultiPoint(type)) {
            return MultiPoint.of(geojson);
        }
        if (GjsonObjectType.isMultiLineString(type)) {
            return MultiLineString.of(geojson);
        }
        if (GjsonObjectType.isMultiPolygon(type)) {
            return MultiPolygon.of(geojson);
        }
        if (GjsonObjectType.isFeature(type)) {
            return Feature.of(geojson);
        }
        if (GjsonObjectType.isFeatureCollection(type)) {
            return FeatureCollection.of(geojson);
        }
        if (GjsonObjectType.isGeometryCollection(type)) {
            return GeometryCollection.of(geojson);
        }
        throw new GjsonDecodeException("Invalid GeoJSON Object.");
    }

    public static String parse(GjsonObject object) {
        return object.toString();
    }

    public static boolean hasCoordinates(String geojson) {
        JSONObject gjson = new JSONObject(geojson);
        return gjson.has(GjsonMember.COORDINATES.toString());
    }

    public static boolean hasType(String geojson) {
        JSONObject gjson = new JSONObject(geojson);
        return gjson.has(GjsonMember.TYPE.toString());
    }

    public static boolean is(String geojson, GjsonObjectType gjsonObjectType) {
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("The GeoJSON object must have a member with the name 'type'.");
        }
        String type = gjson.getString(GjsonMember.TYPE.toString());
        return GjsonObjectType.is(type, gjsonObjectType);
    }

    public static boolean isPoint(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.Point);
    }

    public static boolean isLineString(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.LineString);
    }

    public static boolean isPolygon(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.Polygon);
    }

    public static boolean isMultiPoint(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.MultiPoint);
    }

    public static boolean isMultiLineString(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.MultiLineString);
    }

    public static boolean isMultiPolygon(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.MultiPolygon);
    }

    public static boolean isFeature(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.Feature);
    }

    public static boolean isFeatureCollection(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.FeatureCollection);
    }

    public static boolean isGeometryCollection(String geojson) {
        return Gjson.is(geojson, GjsonObjectType.GeometryCollection);
    }

    public static boolean isTypeAllowed(String type) {
        boolean isFound = false;
        for (GjsonObjectType next : GjsonObjectType.values()) {
            if (!type.equals(next.toString())) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public static boolean isMemberAllowed(String member) {
        boolean isFound = false;
        for (GjsonMember next : GjsonMember.values()) {
            if (!member.equals(next.toString())) continue;
            isFound = true;
            break;
        }
        return isFound;
    }
}

