/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.Gjson;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.LineString;
import terrageo.gjson.MultiLineString;
import terrageo.gjson.MultiPoint;
import terrageo.gjson.MultiPolygon;
import terrageo.gjson.Point;
import terrageo.gjson.Polygon;

public class GeometryCollection
implements GjsonObject,
Iterable<GjsonObject> {
    private GjsonObjectType type = GjsonObjectType.GeometryCollection;
    private List<GjsonObject> geometries;

    public GeometryCollection(List<GjsonObject> geometries) {
        this.geometries = geometries;
    }

    public GeometryCollection(Builder builder) {
        this(builder.gemoetries);
    }

    public GeometryCollection(GjsonObject ... objects) {
        this(Arrays.asList(objects));
    }

    public GeometryCollection() {
    }

    public static GeometryCollection of(String geojson) {
        GeometryCollection gc = new GeometryCollection();
        gc = gc.decode(geojson);
        return gc;
    }

    public static GeometryCollection of(List<GjsonObject> geometries) {
        return new GeometryCollection(geometries);
    }

    public static GeometryCollection of(GjsonObject ... geometries) {
        return new GeometryCollection(geometries);
    }

    public static final GeometryCollection newInstance() {
        return new GeometryCollection();
    }

    @Override
    public GeometryCollection decode(String geojson) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String t = gjson.getString(GjsonMember.TYPE.toString());
        if (!GjsonObjectType.isGeometryCollection(t)) {
            throw new GjsonDecodeException("Invalid Type.");
        }
        this.setType(GjsonObjectType.GeometryCollection);
        if (!gjson.has(GjsonMember.GEOMETRIES.toString())) {
            throw new GjsonDecodeException("An object of type 'FeatureCollection' must have a member with the name 'geometries'.");
        }
        JSONArray shell = gjson.getJSONArray(GjsonMember.GEOMETRIES.toString());
        ArrayList<GjsonObject> stack = new ArrayList<GjsonObject>();
        for (int i = 0; i < shell.length(); ++i) {
            JSONObject object = shell.getJSONObject(i);
            String ids = object.getString(GjsonMember.TYPE.toString());
            if (GjsonObjectType.isPoint(ids)) {
                stack.add(Point.of(object.toString()));
                continue;
            }
            if (GjsonObjectType.isLineString(ids)) {
                stack.add(LineString.of(object.toString()));
                continue;
            }
            if (GjsonObjectType.isPolygon(ids)) {
                stack.add(Polygon.of(object.toString()));
                continue;
            }
            if (GjsonObjectType.isMultiPoint(ids)) {
                stack.add(MultiPoint.of(object.toString()));
                continue;
            }
            if (GjsonObjectType.isMultiLineString(ids)) {
                stack.add(MultiLineString.of(object.toString()));
                continue;
            }
            if (!GjsonObjectType.isMultiPolygon(ids)) continue;
            stack.add(MultiPolygon.of(object.toString()));
        }
        this.setGeometries(stack);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject geometryCollection = new JSONObject();
        geometryCollection.put(GjsonMember.TYPE.toString(), (Object)this.getType());
        JSONArray gc = new JSONArray();
        for (GjsonObject next : this.getGeometries()) {
            gc.put(next.encode());
        }
        geometryCollection.put(GjsonMember.GEOMETRIES.toString(), gc);
        return geometryCollection;
    }

    @Override
    public Enumeration<Point> enumeration() {
        List<GjsonObject> ref = this.getGeometries();
        final ArrayList<Point> stack = new ArrayList<Point>();
        for (GjsonObject current : ref) {
            Enumeration<Point> en = current.enumeration();
            while (en.hasMoreElements()) {
                stack.add(en.nextElement());
            }
        }
        return new Enumeration<Point>(){
            private Iterator<Point> it;
            {
                this.it = stack.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public Iterator<GjsonObject> iterator() {
        if (this.getGeometries() == null) {
            Collections.emptyList().iterator();
        }
        return this.getGeometries().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.type.equals((Object)GjsonObjectType.GeometryCollection)) {
            return false;
        }
        return this.getGeometries() != null && !this.getGeometries().isEmpty();
    }

    @Override
    public void validation() throws GjsonEncodeException {
        if (!this.type.equals((Object)GjsonObjectType.GeometryCollection)) {
            throw new GjsonEncodeException(this);
        }
        if (this.getGeometries() == null || this.getGeometries().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
    }

    @Override
    public String toString(int indent) {
        return this.encode().toString(indent);
    }

    @Override
    public String toString() {
        return this.encode().toString();
    }

    @Override
    public GjsonObjectType getType() {
        return this.type;
    }

    @Override
    public void setType(GjsonObjectType type) {
        this.type = type;
    }

    public List<GjsonObject> getGeometries() {
        return this.geometries;
    }

    public void setGeometries(List<GjsonObject> geometries) {
        this.geometries = geometries;
    }

    public static class Builder {
        public List<GjsonObject> gemoetries = new ArrayList<GjsonObject>();

        public Builder put(GjsonObject geometry) {
            this.gemoetries.add(geometry);
            return this;
        }

        public Builder setGeometries(List<GjsonObject> geometries) {
            this.gemoetries = geometries;
            return this;
        }

        public GeometryCollection build() {
            return new GeometryCollection(this);
        }
    }
}

