/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terrageo.gjson.Feature;
import terrageo.gjson.Gjson;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONArray;
import terrageo.gjson.JSONObject;
import terrageo.gjson.Point;

public class FeatureCollection
implements GjsonObject,
Iterable<Feature> {
    private GjsonObjectType type = GjsonObjectType.FeatureCollection;
    private List<Feature> features;

    public FeatureCollection(List<Feature> features) {
        this.features = features;
    }

    public FeatureCollection(Builder builder) {
        this(builder.features);
    }

    public FeatureCollection(Feature ... features) {
        this(Arrays.asList(features));
    }

    public FeatureCollection() {
    }

    public static final FeatureCollection of(String geojson) {
        FeatureCollection fc = new FeatureCollection();
        fc = fc.decode(geojson);
        return fc;
    }

    public static final FeatureCollection of(List<Feature> features) {
        return new FeatureCollection(features);
    }

    public static final FeatureCollection of(Feature ... features) {
        return new FeatureCollection(features);
    }

    public static final FeatureCollection newInstance() {
        return new FeatureCollection();
    }

    @Override
    public FeatureCollection decode(String geojson) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String t = gjson.getString(GjsonMember.TYPE.toString());
        if (!GjsonObjectType.isFeatureCollection(t)) {
            throw new GjsonDecodeException("Invalid Type.");
        }
        this.setType(GjsonObjectType.FeatureCollection);
        if (!gjson.has(GjsonMember.FEATURES.toString())) {
            throw new GjsonDecodeException("An object of type 'FeatureCollection' must have a member with the name 'features'.");
        }
        JSONArray arr = gjson.getJSONArray(GjsonMember.FEATURES.toString());
        ArrayList<Feature> ref = new ArrayList<Feature>();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject tmp = arr.getJSONObject(i);
            String json = tmp.toString();
            Feature f = Feature.of(json);
            ref.add(f);
        }
        this.setFeatures(ref);
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject featureCollection = new JSONObject();
        featureCollection.put(GjsonMember.TYPE.toString(), (Object)this.getType());
        JSONArray fs = new JSONArray();
        for (Feature next : this.getFeatures()) {
            fs.put(next.encode());
        }
        featureCollection.put(GjsonMember.FEATURES.toString(), fs);
        return featureCollection;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getFeatures() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        final ArrayList<Point> collector = new ArrayList<Point>();
        for (Feature next : this.getFeatures()) {
            Enumeration<Point> en = next.enumeration();
            while (en.hasMoreElements()) {
                collector.add(en.nextElement());
            }
        }
        return new Enumeration<Point>(){
            private final Iterator<Point> iterator;
            {
                this.iterator = collector.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public Point nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public Iterator<Feature> iterator() {
        if (this.getFeatures() == null) {
            Collections.emptyList().iterator();
        }
        return this.getFeatures().iterator();
    }

    @Override
    public boolean isValid() {
        if (!this.type.equals((Object)GjsonObjectType.FeatureCollection)) {
            return false;
        }
        return this.getFeatures() != null && !this.getFeatures().isEmpty();
    }

    @Override
    public void validation() throws GjsonEncodeException {
        if (!this.type.equals((Object)GjsonObjectType.FeatureCollection)) {
            throw new GjsonEncodeException(this);
        }
        if (this.getFeatures() == null || this.getFeatures().isEmpty()) {
            throw new GjsonEncodeException(this);
        }
    }

    @Override
    public String toString(int indent) {
        return this.encode().toString(indent);
    }

    @Override
    public String toString() {
        return this.encode().toString();
    }

    @Override
    public GjsonObjectType getType() {
        return this.type;
    }

    @Override
    public void setType(GjsonObjectType type) {
        this.type = type;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public static class Builder {
        public List<Feature> features = new ArrayList<Feature>();

        public Builder put(Feature f) {
            this.features.add(f);
            return this;
        }

        public Builder setFeatures(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureCollection build() {
            return new FeatureCollection(this);
        }
    }
}

