/*
 * Decompiled with CFR 0.152.
 */
package terrageo.gjson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import terrageo.gjson.Gjson;
import terrageo.gjson.GjsonDecodeException;
import terrageo.gjson.GjsonEncodeException;
import terrageo.gjson.GjsonMember;
import terrageo.gjson.GjsonObject;
import terrageo.gjson.GjsonObjectType;
import terrageo.gjson.JSONObject;
import terrageo.gjson.LineString;
import terrageo.gjson.MultiLineString;
import terrageo.gjson.MultiPoint;
import terrageo.gjson.MultiPolygon;
import terrageo.gjson.Point;
import terrageo.gjson.Polygon;

public class Feature
implements GjsonObject {
    private JSONObject properties = new JSONObject();
    private GjsonObject geometry;
    private GjsonObjectType type = GjsonObjectType.Feature;
    private String id;

    public Feature(Builder builder) {
        this.properties = builder.properties;
        this.geometry = builder.geometry;
        this.id = builder.id;
    }

    public Feature(GjsonObject geometry) {
        this.geometry = geometry;
    }

    public Feature() {
    }

    public static final Feature of(String geojson) {
        Feature f = new Feature();
        f = f.decode(geojson);
        return f;
    }

    @Override
    public Feature decode(String geojson) {
        if (!Gjson.isJSONValid(geojson)) {
            throw new GjsonDecodeException("Invalid JSON.");
        }
        JSONObject gjson = new JSONObject(geojson);
        if (!gjson.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("JSON has no type property.");
        }
        String t = gjson.getString(GjsonMember.TYPE.toString());
        if (!GjsonObjectType.isFeature(t)) {
            throw new GjsonDecodeException("Invalid Type.");
        }
        this.setType(GjsonObjectType.Feature);
        if (gjson.has(GjsonMember.ID.toString())) {
            this.setId(gjson.getString(GjsonMember.ID.toString()));
        }
        if (!gjson.has(GjsonMember.PROPERTIES.toString())) {
            throw new GjsonDecodeException("Feature object must have a member with the name 'properties'.");
        }
        this.setProperties(gjson.getJSONObject(GjsonMember.PROPERTIES.toString()));
        if (!gjson.has(GjsonMember.GEOMETRY.toString())) {
            throw new GjsonDecodeException("Feature object must have a member with the name 'geoemtry'.");
        }
        JSONObject geom = gjson.getJSONObject(GjsonMember.GEOMETRY.toString());
        String json = geom.toString();
        if (!geom.has(GjsonMember.TYPE.toString())) {
            throw new GjsonDecodeException("geometry has no type property.");
        }
        String objectType = geom.getString("type");
        if (GjsonObjectType.isPoint(objectType)) {
            this.setGeometry(Point.of(json));
        } else if (GjsonObjectType.isLineString(objectType)) {
            this.setGeometry(LineString.of(json));
        } else if (GjsonObjectType.isPolygon(objectType)) {
            this.setGeometry(Polygon.of(json));
        } else if (GjsonObjectType.isMultiPoint(objectType)) {
            this.setGeometry(MultiPoint.of(json));
        } else if (GjsonObjectType.isMultiLineString(objectType)) {
            this.setGeometry(MultiLineString.of(json));
        } else if (GjsonObjectType.isMultiPolygon(objectType)) {
            this.setGeometry(MultiPolygon.of(json));
        }
        return this;
    }

    @Override
    public JSONObject encode() {
        this.validation();
        JSONObject feature = new JSONObject();
        feature.put(GjsonMember.TYPE.toString(), (Object)this.getType());
        feature.put(GjsonMember.PROPERTIES.toString(), this.getProperties());
        if (this.getId() != null && !this.getId().isEmpty()) {
            feature.put(GjsonMember.ID.toString(), this.getId());
        }
        feature.put(GjsonMember.GEOMETRY.toString(), this.getGeometry().encode());
        return feature;
    }

    @Override
    public Enumeration<Point> enumeration() {
        if (this.getGeometry() == null) {
            ArrayList tmp = new ArrayList();
            return Collections.enumeration(tmp);
        }
        return this.getGeometry().enumeration();
    }

    @Override
    public boolean isValid() {
        if (!this.type.equals((Object)GjsonObjectType.Feature)) {
            return false;
        }
        if (this.getProperties() == null) {
            return false;
        }
        return this.getGeometry() != null && this.getGeometry().isValid();
    }

    @Override
    public void validation() throws GjsonEncodeException {
        if (!this.type.equals((Object)GjsonObjectType.Feature)) {
            throw new GjsonEncodeException(this);
        }
        if (this.getGeometry() == null || !this.getGeometry().isValid()) {
            throw new GjsonEncodeException(this.getGeometry());
        }
        if (this.getProperties() == null) {
            throw new GjsonEncodeException(this.getGeometry());
        }
    }

    @Override
    public String toString(int indent) {
        return this.encode().toString(indent);
    }

    @Override
    public String toString() {
        return this.encode().toString();
    }

    @Override
    public GjsonObjectType getType() {
        return this.type;
    }

    @Override
    public void setType(GjsonObjectType type) {
        this.type = type;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public void setProperties(JSONObject properties) {
        this.properties = properties;
    }

    public GjsonObject getGeometry() {
        return this.geometry;
    }

    public void setGeometry(GjsonObject geometry) {
        this.geometry = geometry;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class Builder {
        private JSONObject properties = new JSONObject();
        private GjsonObject geometry;
        private String id;

        public Builder setProperties(JSONObject properties) {
            this.properties = properties;
            return this;
        }

        public Builder setGeometry(GjsonObject geometry) {
            this.geometry = geometry;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Feature build() {
            return new Feature(this);
        }
    }
}

