/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import online.shuita.gitee.mojo.utils.HttpUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiUtils {
    private static final Logger log = LoggerFactory.getLogger(WikiUtils.class);

    public static PageInfo getPageIdByTitle(String domainName, String title, Long parentId, String userName, String password) {
        JSONObject jobj;
        JSONArray results;
        String rsltStr = HttpUtils.doGetRequest(String.format("%s/rest/api/content/%s/child/page?expand=version", domainName, parentId), userName, password);
        if (StringUtils.isNotBlank((CharSequence)rsltStr) && null != (results = (jobj = JSONObject.parseObject((String)rsltStr)).getJSONArray("results")) && results.size() > 0) {
            return results.stream().filter(item -> {
                String pagetitle = ((JSONObject)item).getString("title");
                return StringUtils.isNotBlank((CharSequence)pagetitle) && pagetitle.equals(title);
            }).map(item -> PageInfo.builder().id(((JSONObject)item).getLong("id")).version(((JSONObject)item).getJSONObject("version").getInteger("number")).build()).findFirst().orElse(null);
        }
        return null;
    }

    public static PageInfo createNewPage(String domainName, String title, String context, String spaceKey, Long parentId, String userName, String password) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("type", (Object)"page");
        dataObj.put("title", (Object)title);
        dataObj.put("space", (Object)JSONObject.parseObject((String)String.format("{\"key\":\"%s\"}", spaceKey)));
        JSONObject body = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put("value", (Object)context);
        storage.put("representation", (Object)"editor");
        body.put("editor", (Object)storage);
        dataObj.put("body", (Object)body);
        dataObj.put("ancestors", (Object)JSONArray.parseArray((String)String.format("[{\"id\":\"%s\",\"type\":\"page\"}]", parentId)));
        String rsltStr = HttpUtils.doPostJsonData(String.format("%s/rest/api/content", domainName), dataObj.toJSONString(), userName, password);
        if (StringUtils.isNotBlank((CharSequence)rsltStr)) {
            JSONObject jobj = JSONObject.parseObject((String)rsltStr);
            return PageInfo.builder().id(jobj.getLong("id")).version(jobj.getJSONObject("version").getInteger("number")).build();
        }
        return null;
    }

    public static PageInfo updatePageContext(String domainName, String title, String context, String spaceKey, Long pageId, Integer version, String userName, String password) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)pageId);
        dataObj.put("type", (Object)"page");
        dataObj.put("title", (Object)title);
        dataObj.put("space", (Object)JSONObject.parseObject((String)String.format("{\"key\":\"%s\"}", spaceKey)));
        dataObj.put("version", (Object)JSONObject.parseObject((String)String.format("{\"number\":%s}", version)));
        JSONObject body = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put("value", (Object)context);
        storage.put("representation", (Object)"editor");
        body.put("editor", (Object)storage);
        dataObj.put("body", (Object)body);
        String rsltStr = HttpUtils.doPutJsonData(String.format("%s/rest/api/content/%s", domainName, pageId), dataObj.toJSONString(), userName, password);
        if (StringUtils.isNotBlank((CharSequence)rsltStr)) {
            JSONObject jobj = JSONObject.parseObject((String)rsltStr);
            return PageInfo.builder().id(jobj.getLong("id")).version(jobj.getJSONObject("version").getInteger("number")).build();
        }
        return null;
    }

    public static class PageInfo {
        private Long id;
        private Integer version;

        PageInfo(Long id, Integer version) {
            this.id = id;
            this.version = version;
        }

        public static PageInfoBuilder builder() {
            return new PageInfoBuilder();
        }

        public Long getId() {
            return this.id;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public static class PageInfoBuilder {
            private Long id;
            private Integer version;

            PageInfoBuilder() {
            }

            public PageInfoBuilder id(Long id) {
                this.id = id;
                return this;
            }

            public PageInfoBuilder version(Integer version) {
                this.version = version;
                return this;
            }

            public PageInfo build() {
                return new PageInfo(this.id, this.version);
            }

            public String toString() {
                return "WikiUtils.PageInfo.PageInfoBuilder(id=" + this.id + ", version=" + this.version + ")";
            }
        }
    }
}

