/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import online.shuita.gitee.mojo.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtils {
    private static final Logger log = LoggerFactory.getLogger(PackageUtils.class);

    public static List<String> doScan(List<String> basePackageList, boolean findChildren, ClassLoader cl) throws IOException {
        if (null == basePackageList || basePackageList.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList clsList = Lists.newArrayList();
        for (String pkg : basePackageList) {
            PackageUtils.doScan(pkg, findChildren, clsList, cl);
        }
        return clsList;
    }

    private static List<String> doScan(String basePackage, boolean findChildren, List<String> nameList, ClassLoader cl) throws IOException {
        String splashPath = StringUtil.dotToSplash(basePackage);
        URL url = cl.getResource(splashPath);
        String filePath = StringUtil.getRootPath(url);
        List<String> names = null;
        if (PackageUtils.isJarFile(filePath)) {
            if (log.isDebugEnabled()) {
                log.debug("{} \u662f\u4e00\u4e2aJAR\u5305", (Object)filePath);
            }
            names = PackageUtils.readFromJarFile(filePath, splashPath);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("{} \u662f\u4e00\u4e2a\u76ee\u5f55", (Object)filePath);
            }
            names = PackageUtils.readFromDirectory(filePath);
        }
        for (String name : names) {
            if (PackageUtils.isClassFile(name)) {
                nameList.add(PackageUtils.toFullyQualifiedName(name, basePackage));
                continue;
            }
            if (!findChildren) continue;
            PackageUtils.doScan(basePackage + "." + name, findChildren, nameList, cl);
        }
        if (!log.isDebugEnabled()) {
            // empty if block
        }
        for (String n : nameList) {
            log.debug("\u627e\u5230{}", (Object)n);
        }
        return nameList;
    }

    private static String toFullyQualifiedName(String shortName, String basePackage) {
        StringBuilder sb = new StringBuilder(basePackage);
        sb.append('.');
        sb.append(StringUtil.trimExtension(shortName));
        return sb.toString();
    }

    private static List<String> readFromJarFile(String jarPath, String splashedPackageName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("\u4eceJAR\u5305\u4e2d\u8bfb\u53d6\u7c7b: {}", (Object)jarPath);
        }
        JarInputStream jarIn = new JarInputStream(new FileInputStream(jarPath));
        JarEntry entry = jarIn.getNextJarEntry();
        ArrayList<String> nameList = new ArrayList<String>();
        while (null != entry) {
            String name = entry.getName();
            if (name.startsWith(splashedPackageName) && PackageUtils.isClassFile(name)) {
                nameList.add(name);
            }
            entry = jarIn.getNextJarEntry();
        }
        return nameList;
    }

    private static List<String> readFromDirectory(String path) {
        File file = new File(path);
        String[] names = file.list();
        if (null == names) {
            return null;
        }
        return Arrays.asList(names);
    }

    private static boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    private static boolean isJarFile(String name) {
        return name.endsWith(".jar");
    }
}

