/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.generator;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import online.shuita.gitee.mojo.generator.GeneratorManager;
import online.shuita.gitee.mojo.generator.IGenerator;
import online.shuita.gitee.mojo.model.AnalyResult;
import online.shuita.gitee.mojo.model.FieldModel;
import online.shuita.gitee.mojo.model.IntfModel;
import online.shuita.gitee.mojo.model.MethodModel;
import online.shuita.gitee.mojo.model.ParameterModel;
import online.shuita.gitee.mojo.model.PojoModel;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownGenerator
implements IGenerator {
    private static final Logger log = LoggerFactory.getLogger(MarkdownGenerator.class);

    @Override
    public void generateDoc(AnalyResult analyResult, Map<String, String> properties) {
        log.info(properties.get("outPath"));
        String outPath = properties.get("outPath");
        File out = new File(outPath);
        if (!out.isDirectory()) {
            try {
                FileUtils.write((File)out, (CharSequence)"", (String)"utf-8", (boolean)false);
            }
            catch (IOException e) {
                log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", (Throwable)e);
            }
        }
        List<IntfModel> intfList = analyResult.getIntfModelList();
        Map<String, List<IntfModel>> intfMap = intfList.stream().collect(Collectors.groupingBy(IntfModel::getDomain));
        intfMap.entrySet().forEach(entry -> {
            String domain = (String)entry.getKey();
            File curout = out;
            if (out.isDirectory()) {
                curout = new File(out, ("".equals(domain) ? "\u63a5\u53e3\u6587\u6863" : domain) + "-" + System.currentTimeMillis() + ".md");
            }
            try {
                IntfModel intf;
                int idx;
                FileUtils.write((File)curout, (CharSequence)String.format("# %s\u63a5\u53e3\u6e05\u5355  \n", domain), (String)"utf-8", (!out.isDirectory() ? 1 : 0) != 0);
                FileUtils.write((File)curout, (CharSequence)"| \u5e8f\u53f7 | \u63a5\u53e3 | \u4e2d\u6587\u540d | \u5907\u6ce8 |  \n", (String)"utf-8", (boolean)true);
                FileUtils.write((File)curout, (CharSequence)"| --- | --- | --- | --- |  \n", (String)"utf-8", (boolean)true);
                List sublist = (List)entry.getValue();
                for (idx = 0; idx < sublist.size(); ++idx) {
                    intf = (IntfModel)sublist.get(idx);
                    FileUtils.write((File)curout, (CharSequence)String.format("| %s | [%s](#anchor%s) | %s | %s |  \n", idx + 1, this.converterHtmlStr(intf.getIntfShortName()), idx + 1, intf.getIntfDesc(), ""), (String)"utf-8", (boolean)true);
                }
                for (idx = 0; idx < sublist.size(); ++idx) {
                    intf = (IntfModel)sublist.get(idx);
                    FileUtils.write((File)curout, (CharSequence)String.format("### <span id=\"anchor%s\" name=\"anchor%s\">%s\u3001%s</span>  \n", idx + 1, idx + 1, idx + 1, this.converterHtmlStr(intf.getIntfShortName())), (String)"utf-8", (boolean)true);
                    List<MethodModel> methodModelList = intf.getMethodModelList();
                    for (int midx = 0; midx < methodModelList.size(); ++midx) {
                        this.generateMethodDoc(idx, midx, methodModelList.get(midx), curout, analyResult.getPojoModelMap());
                    }
                }
            }
            catch (IOException e) {
                log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private void generateMethodDoc(int intfIdx, int methodIdx, MethodModel methodModel, File curout, Map<String, List<PojoModel>> pojoModelMap) {
        try {
            FileUtils.write((File)curout, (CharSequence)String.format("#### %s.%s\u3001%s%s%s  \n", intfIdx + 1, methodIdx + 1, methodModel.getDeprecated() != false ? "~~" : "", this.converterHtmlStr(methodModel.getMethodName()), methodModel.getDeprecated() != false ? "~~" : ""), (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"**\u63a5\u53e3\u540d\uff1a**  \n", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)String.format("%s  \n", this.converterHtmlStr(methodModel.getMethodName())), (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"**\u63a5\u53e3\u8bf4\u660e\uff1a**  \n", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)String.format("%s  \n", methodModel.getMethodDesc()), (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"**\u5165\u53c2\uff1a**  \n", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"<table>", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"<tr><th>\u5b57\u6bb5\u540d</th><th>\u7c7b\u578b</th><th>\u662f\u5426\u5fc5\u586b</th><th>\u5b57\u6bb5\u63cf\u8ff0</th></tr>", (String)"utf-8", (boolean)true);
            List<ParameterModel> paramList = methodModel.getParameterModelList();
            ArrayList pojoModelList = Lists.newArrayList();
            for (int pidx = 0; pidx < paramList.size(); ++pidx) {
                ParameterModel parm = paramList.get(pidx);
                FileUtils.write((File)curout, (CharSequence)String.format("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>", this.converterHtmlStr(parm.getParameterName()), this.converterHtmlStr(parm.getTypeShotName()), "\u5426", parm.getDesc()), (String)"utf-8", (boolean)true);
                if (!pojoModelMap.containsKey(parm.getGenericType())) continue;
                pojoModelList.addAll((Collection)pojoModelMap.get(parm.getGenericType()));
            }
            if (null != pojoModelList) {
                ArrayList generatePojo = Lists.newArrayList();
                this.generatePojoDoc(pojoModelList.stream().distinct().collect(Collectors.toList()), curout, pojoModelMap, generatePojo);
            }
            FileUtils.write((File)curout, (CharSequence)"</table>\n\n", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"**\u51fa\u53c2\uff1a**  \n", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"<table>\n", (String)"utf-8", (boolean)true);
            FileUtils.write((File)curout, (CharSequence)"<tr><th>\u5b57\u6bb5\u540d</th><th>\u7c7b\u578b</th><th>\u662f\u5426\u5fc5\u586b</th><th>\u5b57\u6bb5\u63cf\u8ff0</th></tr>\n", (String)"utf-8", (boolean)true);
            ArrayList outPojoModelList = Lists.newArrayList();
            if (pojoModelMap.containsKey(methodModel.getReturnGenericType())) {
                outPojoModelList.addAll((Collection)pojoModelMap.get(methodModel.getReturnGenericType()));
            } else {
                FileUtils.write((File)curout, (CharSequence)String.format("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", "returnValue", this.converterHtmlStr(methodModel.getReturnTypeShotName()), "\u662f", ""), (String)"utf-8", (boolean)true);
            }
            if (null != outPojoModelList) {
                ArrayList generatePojo = Lists.newArrayList();
                this.generatePojoDoc(outPojoModelList.stream().distinct().collect(Collectors.toList()), curout, pojoModelMap, generatePojo);
            }
            FileUtils.write((File)curout, (CharSequence)"</table>\n\n", (String)"utf-8", (boolean)true);
        }
        catch (IOException e) {
            log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", (Throwable)e);
        }
    }

    private void generatePojoDoc(List<PojoModel> pojoModels, File curout, Map<String, List<PojoModel>> pojoModelMap, List<String> generatePojo) {
        pojoModels.forEach(pojo -> {
            if (generatePojo.contains(pojo.getType())) {
                return;
            }
            try {
                FileUtils.write((File)curout, (CharSequence)String.format("<tr><td colspan=\"4\"><b><i>%s</i><b></td></tr>\n", this.converterHtmlStr(pojo.getShortType())), (String)"utf-8", (boolean)true);
                List<FieldModel> paramList = pojo.getFieldEntryList();
                ArrayList pojoModelList = Lists.newArrayList();
                for (int pidx = 0; pidx < paramList.size(); ++pidx) {
                    FieldModel parm = paramList.get(pidx);
                    FileUtils.write((File)curout, (CharSequence)String.format("<tr><td>%s%s%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", parm.getDeprecated() != false ? "<del>" : "", this.converterHtmlStr(parm.getName()), parm.getDeprecated() != false ? "</del>" : "", this.converterHtmlStr(parm.getShortType()), "\u5426", parm.getDesc()), (String)"utf-8", (boolean)true);
                    if (!pojoModelMap.containsKey(parm.getGenericType())) continue;
                    pojoModelList.addAll((Collection)pojoModelMap.get(parm.getGenericType()));
                }
                generatePojo.add(pojo.getType());
                if (null != pojoModelList && pojoModelList.size() > 0) {
                    this.generatePojoDoc(pojoModelList.stream().distinct().collect(Collectors.toList()), curout, pojoModelMap, generatePojo);
                }
            }
            catch (IOException e) {
                log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private String converterHtmlStr(String str) {
        return str.replaceAll("<=", "<= &le;").replaceAll(">=", "&ge;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    static {
        try {
            GeneratorManager.getManager().registGenerator((IGenerator)MarkdownGenerator.class.newInstance());
            log.info("\u6ce8\u518c\u6210\u529f");
        }
        catch (Throwable e) {
            log.error("regist error", e);
        }
    }
}

