package online.shuita.gitee.mojo.utils;

import okhttp3.*;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class HttpUtils {
    public static String doPutJsonData(String url, String data) {
        return doPutJsonData(url, data, null, null);
    }

    public static String doPutJsonData(String url, String data, String userName, String password) {
        OkHttpClient okHttpClient = null;
        if (StringUtils.isNotBlank(userName) && StringUtils.isNotBlank(password)) {
            okHttpClient = new OkHttpClient.Builder()
                    .addInterceptor(new BasicAuthInterceptor(userName, password))
                    .connectTimeout(30, TimeUnit.SECONDS)
                    .readTimeout(60, TimeUnit.SECONDS)
                    .writeTimeout(60, TimeUnit.SECONDS)
                    .build();
        } else {
            okHttpClient = new OkHttpClient();
        }

        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(JSON, data);

        Request request = new Request.Builder()
                .url(url)
                .put(body)
                .build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            String rslt = response.body().string();
            System.out.println(rslt);
            return rslt;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String doPostJsonData(String url, String data) {
        return doPostJsonData(url, data, null, null);
    }

    public static String doPostJsonData(String url, String data, String userName, String password) {
        OkHttpClient okHttpClient = null;
        if (StringUtils.isNotBlank(userName) && StringUtils.isNotBlank(password)) {
            okHttpClient = new OkHttpClient.Builder()
                    .addInterceptor(new BasicAuthInterceptor(userName, password))
                    .connectTimeout(30, TimeUnit.SECONDS)
                    .readTimeout(60, TimeUnit.SECONDS)
                    .writeTimeout(60, TimeUnit.SECONDS)
                    .build();
        } else {
            okHttpClient = new OkHttpClient();
        }

        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(JSON, data);

        Request request = new Request.Builder()
                .url(url)
                .post(body)
                .build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            String rslt = response.body().string();
            System.out.println(rslt);
            return rslt;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String doGetRequest(String url) {
        return doGetRequest(url, null, null);
    }

    public static String doGetRequest(String url, String userName, String password) {
        OkHttpClient okHttpClient = null;
        if (StringUtils.isNotBlank(userName) && StringUtils.isNotBlank(password)) {
            okHttpClient = new OkHttpClient.Builder()
                    .addInterceptor(new BasicAuthInterceptor(userName, password))
                    .connectTimeout(30, TimeUnit.SECONDS)
                    .readTimeout(60, TimeUnit.SECONDS)
                    .writeTimeout(60, TimeUnit.SECONDS)
                    .build();
        } else {
            okHttpClient = new OkHttpClient();
        }
        Request request = new Request.Builder()
                .url(url)
                .build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            String rslt = response.body().string();
            System.out.println(rslt);
            return rslt;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class BasicAuthInterceptor implements Interceptor {
        private String credentials;


        public BasicAuthInterceptor(String user, String password) {
            this.credentials = Credentials.basic(user, password);
        }

        @Override
        public Response intercept(Chain chain) throws IOException {
            Request request = chain.request();
            Request authenticatedRequest = request.newBuilder()
                    .header("Authorization", credentials).build();
            return chain.proceed(authenticatedRequest);
        }
    }

    public static void main(String[] args) {
//        HttpUtils.doGetRequest("https://wiki.amh-group.com/rest/api/content/146506805/child/page?expand=version", "han.wang6@amh-group.com", "P@ssW0rd0216");
//        HttpUtils.doGetRequest("https://wiki.amh-group.com/rest/api/content/266080886", "han.wang6@amh-group.com", "P@ssW0rd0216");

//        String data="{\"type\":\"page\",\"title\":\"Test page1\",\"space\":{\"key\":\"~han.wang6@amh-group.com\"},\"body\":{\"storage\":{\"value\":\"<p>This is <br/> a new page</p>\",\"representation\":\"storage\"}},\"ancestors\":[{\"id\":\"146506805\",\"type\":\"page\"}]}";
//        HttpUtils.doPostJsonData("https://wiki.amh-group.com/rest/api/content", data,"han.wang6@amh-group.com", "P@ssW0rd0216");

        String data = "{\"id\":\"266080886\",\"type\":\"page\",\"title\":\"Test page aaa 1\",\"space\":{\"key\":\"~han.wang6@amh-group.com\"},\"body\":{\"storage\":{\"value\":\"<p>This is <br/> a new page</p>\",\"representation\":\"storage\"}},\n" +
                "\"version\":{\"number\":2}}}";
        HttpUtils.doPutJsonData("https://wiki.amh-group.com/rest/api/content/266080886", data, "han.wang6@amh-group.com", "P@ssW0rd0216");
    }
}
