/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import online.shuita.gitee.mojo.generator.GeneratorManager;
import online.shuita.gitee.mojo.generator.IGenerator;
import online.shuita.gitee.mojo.model.AnalyResult;
import online.shuita.gitee.mojo.service.IntfService;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class generatorMojo
extends AbstractMojo {
    @Parameter(property="targetClass")
    private String targetClass;
    @Parameter(property="generator", defaultValue="online.shuita.gitee.mojo.generator.MarkdownGenerator")
    private String generator;
    @Parameter(property="generatorExtParams")
    private Map<String, String> generatorExtParams;
    @Parameter(property="project.build.directory", required=true)
    private File outputDirectory;
    @Parameter(property="project.build.sourceDirectory", required=true, readonly=true)
    private File sourcedir;
    @Parameter(property="project.basedir", required=true, readonly=true)
    private File basedir;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List<String> compileClasspathElements;
    private URLClassLoader loader;
    @Parameter(defaultValue="${project}")
    public MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)this.targetClass);
        this.getLog().info((CharSequence)this.outputDirectory.getPath());
        this.getLog().info((CharSequence)this.sourcedir.getPath());
        this.getLog().info((CharSequence)this.basedir.getPath());
        this.getLog().info((CharSequence)String.join((CharSequence)",", this.compileClasspathElements));
        if (null != this.targetClass && !"".equalsIgnoreCase(this.targetClass)) {
            try {
                Class<IGenerator> generatorInst;
                Class.forName("online.shuita.gitee.mojo.generator.MarkdownGenerator");
                if (StringUtils.isNotBlank((CharSequence)this.generator) && !"online.shuita.gitee.mojo.generator.MarkdownGenerator".equalsIgnoreCase(this.generator)) {
                    Class.forName(this.generator);
                }
                if (null == (generatorInst = GeneratorManager.getManager().getGenerator(this.generator))) {
                    this.getLog().error((CharSequence)String.format("\u6587\u6863\u751f\u6210\u5668[%s]\u627e\u4e0d\u5230", this.generator));
                    generatorInst = GeneratorManager.getManager().getGenerator("online.shuita.gitee.mojo.generator.MarkdownGenerator");
                }
                ClassLoader loader = this.getClassLoader(this.project);
                Class<?> target = loader.loadClass(this.targetClass);
                this.getLog().info((CharSequence)target.getName());
                IntfService service = new IntfService();
                service.setCompileClasspathElements(this.compileClasspathElements);
                service.setSourceBasePath(this.sourcedir.getPath());
                AnalyResult model = service.doAnalyse(target, loader);
                this.getLog().info((CharSequence)model.toString());
                this.getLog().info((CharSequence)this.getPluginContext().toString());
                generatorInst.newInstance().generateDoc(model, this.generatorExtParams);
            }
            catch (ClassNotFoundException e) {
                this.getLog().error((CharSequence)"\u5f85\u5904\u7406\u7684\u7c7b\u4e0d\u5b58\u5728", (Throwable)e);
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"\u5904\u7406\u5f02\u5e38", e);
            }
        }
    }

    private ClassLoader getClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getCompileClasspathElements();
            classpathElements.add(project.getBuild().getOutputDirectory());
            classpathElements.add(project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Couldn't get the classloader.");
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }
}

