/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.sendEmail;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import online.sanen.sendEmail.Mail;
import online.sanen.sendEmail.SMTP;

public class SMTPEmail
implements SMTP {
    private Mail email;

    @Override
    public boolean send(Mail mail) {
        try {
            Properties prop = new Properties();
            prop.setProperty("mail.smtp.host", mail.getHost());
            prop.setProperty("mail.smtp.port", String.valueOf(mail.getPort()));
            prop.setProperty("mail.smtp.auth", "true");
            MyAuthenticator au = new MyAuthenticator(mail.getUsername(), mail.getPassword());
            Session session = Session.getDefaultInstance((Properties)prop, (Authenticator)au);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(mail.getFrom(), mail.getNick()));
            String[] toAddresss = mail.getTo().split("[\uff1b;,\uff0c\\s]{1}");
            InternetAddress[] address = new InternetAddress[toAddresss.length];
            for (int i = 0; i < toAddresss.length; ++i) {
                address[i] = new InternetAddress(toAddresss[i]);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])address);
            message.setSubject(mail.getSubject());
            message.setSentDate(new Date());
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart content = new MimeBodyPart();
            content.setContent((Object)mail.getContent(), "text/html;charset=utf-8");
            mp.addBodyPart((BodyPart)content);
            String path = mail.getAccessorypath();
            if (!Validate.isNullOrEmpty((Object)path)) {
                File file = new File(path);
                List<File> files = new ArrayList<File>();
                if (file.exists() && file.isDirectory()) {
                    files = FileUtility.childies((File)new File(path));
                }
                if (file.exists() && file.isFile()) {
                    files.add(file);
                }
                for (File f : files) {
                    MimeBodyPart accessory = new MimeBodyPart();
                    FileDataSource sourse = new FileDataSource(f.getAbsolutePath());
                    DataHandler data = new DataHandler((DataSource)sourse);
                    accessory.setDataHandler(data);
                    accessory.setFileName(MimeUtility.encodeText((String)sourse.getName()));
                    mp.addBodyPart((BodyPart)accessory);
                }
            }
            message.setContent((Multipart)mp);
            Transport.send((Message)message);
            return true;
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001\u5931\u8d25");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Mail loadConfig(File mailConfig) {
        try {
            this.email = new Mail(mailConfig);
            return this.email;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setMail(Mail m) {
        if (m == null) {
            throw new NullPointerException("Mail is null");
        }
        this.email = m;
    }

    @Override
    public boolean send() {
        if (this.email == null) {
            throw new NullPointerException("Mail is null");
        }
        return this.send(this.email);
    }

    @Override
    public Mail getMail() {
        return this.email;
    }

    class MyAuthenticator
    extends Authenticator {
        private String strUser;
        private String strPwd;

        public MyAuthenticator(String user, String password) {
            this.strUser = user;
            this.strPwd = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.strUser, this.strPwd);
        }
    }
}

