/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.sendEmail;

import com.mhdt.analyse.Validate;
import com.mhdt.io.FileIO;
import com.mhdt.parse.Properties;
import com.mhdt.toolkit.Bean;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeUtility;

public class Mail {
    private String from;
    private String username;
    private String password;
    private String nick = "";
    private int port = 25;
    private String host;
    private String to;
    private String subject;
    private String content;
    private String accessorypath;
    private Map<String, String> params = new HashMap<String, String>();

    public Mail() {
    }

    public Mail(String username, String password, String host) {
        this.username = username;
        this.from = username;
        this.password = password;
        this.host = host;
    }

    public Mail(File config) throws IOException {
        Properties pro = new Properties();
        pro.load(config);
        Mail email = (Mail)Bean.parse(Mail.class, (Map)pro.map());
        this.username = email.username;
        this.password = email.password;
        this.from = email.from;
        this.nick = Validate.isNullOrEmpty((Object)email.nick) ? this.nick : email.nick;
        this.port = Validate.isNullOrEmpty((Object)email.port) ? this.port : email.port;
        this.host = email.host;
        this.to = email.to;
        this.subject = email.subject;
        this.content = email.content;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        String temp = new String(this.content);
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            temp = temp.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return temp;
    }

    public void setContent(String content) {
        this.content = content;
        if (!Validate.isNullOrEmpty((Object)this.content) && this.content.startsWith("file@")) {
            File file = new File(this.content.substring(content.indexOf("@") + 1));
            this.content = FileIO.getContent((File)file);
        }
    }

    public String getAccessorypath() {
        return this.accessorypath;
    }

    public void setAccessorypath(String accessorypath) {
        this.accessorypath = accessorypath;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        try {
            nick = MimeUtility.encodeText((String)"sanen Service");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            nick = "";
        }
        this.nick = nick;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setParam(String param, String value) {
        this.params.put(param, value);
    }

    public void clearParams() {
        this.params.clear();
    }

    public String toString() {
        return "Mail [from=" + this.from + "\n, username=" + this.username + "\n, password=" + this.password + "\n, port=" + this.port + "\n, host=" + this.host + "\n, to=" + this.to + "\n, subject=" + this.subject + "\n, content=" + this.content + "\n, accessorypath=" + this.accessorypath + "]";
    }
}

