package online.sanen.sendEmail;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;


import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.FileUtility;

/**
 * @author：LazyToShow <br>
 * Date: 2016-05-13 <br>
 * Time: 上午10:14:05
 */
public class SMTPEmail implements SMTP {

	private Mail email;

	public boolean send(Mail mail) {

		try {

			// param
			Properties prop = new Properties();

			// server host
			prop.setProperty("mail.smtp.host", mail.getHost());

			// server port
			prop.setProperty("mail.smtp.port", String.valueOf(mail.getPort()));

			// Whether to adopt the certification
			prop.setProperty("mail.smtp.auth", "true");

			// validate userName and passWord
			MyAuthenticator au = new MyAuthenticator(mail.getUsername(), mail.getPassword());

			/** To the session object parameter and validation account. */
			Session session = Session.getDefaultInstance(prop, au);

			/** Create E-mail information carrier. */
			Message message = new MimeMessage(session);

			message.setFrom(new InternetAddress(mail.getFrom(), mail.getNick()));

			// add Receiveies
			String toAddresss[] = mail.getTo().split("[；;,，\\s]{1}");

			InternetAddress[] address = new InternetAddress[toAddresss.length];

			for (int i = 0; i < toAddresss.length; i++) {
				address[i] = new InternetAddress(toAddresss[i]);
			}

			message.setRecipients(Message.RecipientType.TO, address);

			message.setSubject(mail.getSubject());

			message.setSentDate(new Date());

			/** set content */
			Multipart mp = new MimeMultipart();
			MimeBodyPart content = new MimeBodyPart();
			content.setContent(mail.getContent(), "text/html;charset=utf-8");
			mp.addBodyPart(content);

			/** post attachperm */
			String path = mail.getAccessorypath();
			if (!Validate.isNullOrEmpty(path)) {
				File file = new File(path);
				List<File> files = new ArrayList<>();

				if (file.exists() && file.isDirectory()) {/** if path is folder */
					files = FileUtility.childies(new File(path));
				}

				if (file.exists() && file.isFile()) {/** if path is a file */
					files.add(file);
				}

				for (File f : files) {
					MimeBodyPart accessory = new MimeBodyPart();
					FileDataSource sourse = new FileDataSource(f.getAbsolutePath());
					DataHandler data = new DataHandler(sourse);
					accessory.setDataHandler(data);
					accessory.setFileName(MimeUtility.encodeText(sourse.getName()));
					mp.addBodyPart(accessory);
				}
			}

			message.setContent(mp);
			Transport.send(message);
			return true;
		} catch (Exception e) {
			System.err.println("发送失败");
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * 邮箱认证
	 * 
	 * @author：Ellrien
	 * @date: 2013-10-10 上午11:07:36
	 * @version: 1.0
	 */
	class MyAuthenticator extends javax.mail.Authenticator {
		private String strUser;
		private String strPwd;

		public MyAuthenticator(String user, String password) {
			this.strUser = user;
			this.strPwd = password;
		}

		protected PasswordAuthentication getPasswordAuthentication() {
			return new PasswordAuthentication(strUser, strPwd);
		}

	}

	@Override
	public Mail loadConfig(File mailConfig) {
		try {
			this.email = new Mail(mailConfig);
			return this.email;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}

	}

	@Override
	public void setMail(Mail m) {
		if (m == null) {
			throw new NullPointerException("Mail is null");
		}
		this.email = m;
	}

	@Override
	public boolean send() {
		if (email == null)
			throw new NullPointerException("Mail is null");
		return send(this.email);
	}

	@Override
	public Mail getMail() {
		return this.email;
	}

}
