package com.mhdt.net;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

import com.mhdt.net.Urls.Downloading;
import com.mhdt.toolkit.Assert;
import com.mhdt.toolkit.FileUtility.FileType;

/**
 * 
 * @author LazyToShow <br>
 *         Date: Jan 31, 2019 <br>
 *         Time: 5:52:26 PM <br>
 */
public class SimpleDownload implements Download {

	public SimpleDownload(String url, File dest, FileType destFileType) {
		this.url = url;
		this.dest = dest;
		this.destFileType = destFileType;
	}

	Consumer<HttpURLConnection> connConsumer;

	@Override
	public Download configureLink(Consumer<HttpURLConnection> connConsumer) {
		this.connConsumer = connConsumer;
		return this;
	}

	Downloading loading;

	@Override
	public Download setLoading(Downloading loading) {
		this.loading = loading;
		return this;
	}

	String url;

	File dest;

	FileType destFileType;

	@Override
	public void get() throws MalformedURLException, IOException {
		Urls.downLoad(url, dest, destFileType, headers, connConsumer, loading);
	}

	Map<String, String> headers;

	@Override
	public Download addHeader(String key, String value) {
		
		Assert.notNull(key, "The header key is null");
		Assert.notNull(value, "The header value is null");
		
		if(headers == null)
			headers = new HashMap<>();
		
		headers.put(key, value);
		return this;
	}

}
