package com.mhdt.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.function.Consumer;

import com.mhdt.net.Urls.Downloading;

/**
 * 
 * @author LazyToShow <br>
 * Date: Jan 31, 2019 <br>
 * Time: 5:45:20 PM <br>
 */
public interface Download {
	
	Download configureLink(Consumer<HttpURLConnection> consumer);
	
	Download setLoading(Downloading loading);
	
	Download addHeader(String key,String value);
	
	void get() throws MalformedURLException, IOException;

	
	public static class DownInfo {

		long current;

		long length;

		String fileName;

		public DownInfo(int length, String fileName) {
			this.length = length;
			this.fileName = fileName;

		}

		public long getCurrent() {
			return current;
		}

		public void setCurrent(long current) {
			this.current = current;
		}

		public long getLength() {
			return length;
		}

		public void setLength(long length) {
			this.length = length;
		}

		public void addLength(int add) {
			this.length += add;
		}

		public String getFileName() {
			return fileName;
		}

		public void setFileName(String fileName) {
			this.fileName = fileName;
		}
	}

}
