package com.mhdt.patterns.event;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author LazyToShow <br>
 *         Date: Mar 1, 2019 <br>
 *         Time: 4:51:12 PM <br>
 */
public class EventBus {
	
	Logger log = LoggerFactory.getLogger(EventBus.class);

	String identifier;

	SubscriberRegistry subscribers = new SubscriberRegistry();

	ExceptionHandler exceptionHandler;

	public EventBus(String identifier) {
		this.identifier = identifier;
	}

	public EventBus(String identifier, ExceptionHandler exceptionHandler) {
		this.identifier = identifier;
		this.exceptionHandler = exceptionHandler;
	}

	public void register(Object object) {
		subscribers.register(object);
	}

	public void unregister(Object object) {
		subscribers.unregister(object);
	}

	public void post(Object event) {

		Iterator<Subscriber> eventSubscribers = subscribers.getSubscribers(event);
		
		if(eventSubscribers ==null) {
			log.debug("EventSubscribers is null.");
			return;
		}
			

		while (eventSubscribers.hasNext()) {

			Subscriber subscriber = eventSubscribers.next();

			try {
				subscriber.invoke(event);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				if (exceptionHandler != null)
					exceptionHandler.handler(subscriber, event, e);
			}
		}

	}

}
