package com.mhdt.toolkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * 集合工具类
 * 
 * <pre>
 *
 * @author LazyToShow <br>
 * Date: 2017年2月16日 <br>
 * Time: 下午10:29:45
 * </pre>
 */
public class Collections {

	/**
	 * 语法类似Mysql的limit操作.如果提取数量小于Count返回最大提取数.
	 * 
	 * @param collecttion - 数据源
	 * @param start       - 从第几个元素开始
	 * @param count       - 提取数量
	 * @return Collection;取不到元素返回空的ArrayList
	 */
	public static <T> ArrayList<T> limit(Collection<T> collecttion, int start, int count) {
		ArrayList<T> list = new ArrayList<T>();
		// 判断获取不到直接返回空结果
		if (collecttion == null || collecttion.isEmpty())
			return list;

		Iterator<T> it = collecttion.iterator();

		for (int i = 0; i < collecttion.size() && it.hasNext(); i++) {
			T t = it.next();
			if (i < start)
				continue;
			if (count > 0 && list.size() == count)
				break;
			list.add(t);
		}

		return list;

	}

	public static String toString(Object[] array) {
		StringBuilder sb = new StringBuilder();
		for (Object t : array)
			sb.append(t.toString() + "\n");
		return sb.toString();
	}

	public static <T> String toString(Collection<T> list) {
		StringBuilder sb = new StringBuilder();
		for (T t : list)
			sb.append(t.toString() + "\n");

		return sb.toString();
	}

	/**
	 * Set rotation array。
	 * 
	 * @param cls
	 * @param list
	 * @param function
	 * @return
	 */
	public static <T, R> R[] toArray(Class<R> cls, Collection<T> list, Function<T, R> function) {
		List<R> result = new ArrayList<>();
		list.forEach(it -> {
			result.add(function.apply(it));
		});
		return result.toArray(Reflect.newArray(cls, result.size()));
	}


	@SafeVarargs
	public static <T> List<T> asList(T... objs) {

		if (objs == null)
			return java.util.Collections.emptyList();
		
		return Arrays.asList(objs);
	}

	public static Map<String, Object> asMap(String key, Object value) {
		return new HashMap<String, Object>(1){
			private static final long serialVersionUID = 1L;

			{
				put(key, value);
			}
		};
	}

	public static Map<String, Object> asMap(String k1, Object v1, String k2, Object v2) {
		return new HashMap<String, Object>(1){
			private static final long serialVersionUID = 1L;

			{
				put(k1, v1);
				put(k2, v2);
			}
		};
	}
	
	public static Map<String, Object> asMap(String k1, Object v1, String k2, Object v2,String k3, Object v3) {
		return new HashMap<String, Object>(1){
			private static final long serialVersionUID = 1L;

			{
				put(k1, v1);
				put(k2, v2);
				put(k3, v3);
			}
		};
	}
	
	public static Map<String, Object> asMap(String k1, Object v1, String k2, Object v2,String k3, Object v3,String k4, Object v4) {
		return new HashMap<String, Object>(1){
			private static final long serialVersionUID = 1L;

			{
				put(k1, v1);
				put(k2, v2);
				put(k3, v3);
				put(k4, v4);
			}
		};
	}
	
	public static Map<String, Object> asMap(String k1, Object v1, String k2, Object v2,String k3, Object v3,String k4, Object v4,String k5, Object v5) {
		return new HashMap<String, Object>(1){
			private static final long serialVersionUID = 1L;

			{
				put(k1, v1);
				put(k2, v2);
				put(k3, v3);
				put(k4, v4);
				put(k5, v5);
			}
		};
	}

	public static <T> List<T> copyObject(T t, int size) {
		List<T> list = new ArrayList<>();
		for(int i=0;i<size;i++) {
			list.add(t);
		}
		return list;
	}

	public static Map<String, Object> asMap(Collection<String> keys, List<Object> values) {
		Map<String,Object> map = new HashMap<String, Object>();
		
		int i =0;
		for (Iterator<String> iterator = keys.iterator(); iterator.hasNext();)
			map.put(iterator.next(), values.get(i++));
		
		return map;
	}

}
