package com.mhdt.patterns.event;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author LazyToShow <br>
 * Date: Mar 1, 2019 <br>
 * Time: 4:29:46 PM <br>
 */
public class SubscriberRegistry {
	
	Logger log = LoggerFactory.getLogger(EventBus.class);
	
	Map<Class<?>,CopyOnWriteArrayList<Subscriber>> listeners = new ConcurrentHashMap<>();

	public void register(Object listener) {
		
		
		for(Method method :listener.getClass().getMethods()) {
			
			if(method.isAnnotationPresent(Subscribe.class)) {
				
				log.debug("Registed  Subscribe.class :{} , method: {}",listener.getClass(),method.getName());

				
				if(method.getParameterTypes().length>0) {
					Class<?> paramerClass = method.getParameterTypes()[0];
					
					CopyOnWriteArrayList<Subscriber> list = listeners.get(paramerClass);
					
					if(list ==null) {
						listeners.put(paramerClass,list = new CopyOnWriteArrayList<>() );
						log.debug("registed {}",paramerClass);
					}
					
					list.add(new Subscriber(listener, method));
				}
				
			}
			
		}
		
	}

	public void unregister(Object listener) {
		
		for(Method method :listener.getClass().getMethods()) {
			
			if(method.isAnnotationPresent(Subscribe.class) && method.getParameterTypes().length>0) {
				
					Class<?> paramerClass = method.getParameterTypes()[0];
					
					
					CopyOnWriteArrayList<Subscriber> copyOnWriteArrayList = listeners.get(paramerClass);
					
					if(copyOnWriteArrayList == null)
						continue;
					
					if(copyOnWriteArrayList.size()==1 && copyOnWriteArrayList.get(0).getObject()==listener) {
						listeners.remove(paramerClass);
					}else {
						copyOnWriteArrayList.forEach(item->{
							
							if(item.getObject() == listener)
								copyOnWriteArrayList.remove(item);
								
						});
					}
					
			}
		}
		
	}

	public Iterator<Subscriber> getSubscribers(Object event) {
		
		CopyOnWriteArrayList<Subscriber> list = listeners.get(event.getClass());
		return list==null?null:list.iterator();
	}


}
