package com.mhdt.io;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mhdt.degist.DegistTool;
import com.mhdt.patterns.event.EventBus;
import com.mhdt.scheduler.Scheduler;
import com.mhdt.scheduler.Schedulers;
import com.mhdt.toolkit.Assert;

/**
 * 
 * @author laztToShow <br>
 *         Date: 2019/01/24 <br>
 *         Time: 10:28
 *
 */
public class FileObservation {
	
	Logger log = LoggerFactory.getLogger(EventBus.class);

	public File file;

	String md5;

	EventBus eventBus = new EventBus("File listener");

	static Scheduler scheduler = Schedulers.singleThreadSchedule();

	public FileObservation(File file) {

		Assert.notNull(file, "File is null");
		Assert.state(file.exists(), "File does not exist: " + file.getAbsolutePath());
		Assert.state(file.isFile(), "Not a legal file");

		this.file = file;
		this.md5 = DegistTool.md5(file);

		Timer timer = new Timer();
		timer.schedule(new TimerTask() {

			@Override
			public void run() {

				String newMd5 = DegistTool.md5(file);
				
				if (!newMd5.equals(FileObservation.this.md5)) {
					FileObservation.this.md5 = newMd5;
					eventBus.post(file);
				}

			}

		}, 2000, 2000);

	}
	

	public void registered(Object subscriber) {
		log.debug("start registe listen:"+subscriber.getClass());
		eventBus.register(subscriber);
	}

}
