package com.mhdt.degist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;

import com.mhdt.io.FileIO;

import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

/**
 * 需要依赖freemarker
 * 
 * @author LazyToShow <br>
 *         Date: Feb 25, 2019 <br>
 *         Time: 3:06:07 PM <br>
 */
public class FreeMarker {

	Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
	StringTemplateLoader stringLoader;

	public FreeMarker() {
		super();
		// TODO Auto-generated constructor stub
	}

	public FreeMarker(File file) {
		try {
			loadDirectoryTemplate(file);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public FreeMarker(Class<?> cls) {
		try {
			File file = new File(cls.getResource("").toURI().toString());
			loadDirectoryTemplate(file);
		} catch (URISyntaxException | IOException e) {
			e.printStackTrace();
		}
	}

	public void loadInputStream(String name, InputStream inputStream) {

		if (stringLoader == null) {
			stringLoader = new StringTemplateLoader();
			configuration.setTemplateLoader(stringLoader);
		}

		stringLoader.putTemplate(name, FileIO.getContent(inputStream));
	}

	public void loadStringTemplate(String name, String template) {
		if (stringLoader == null) {
			stringLoader = new StringTemplateLoader();
			configuration.setTemplateLoader(stringLoader);
		}

		stringLoader.putTemplate(name, template);
	}

	public void loadDirectoryTemplate(File directory) throws IOException {
		configuration.setDirectoryForTemplateLoading(directory);
	}

	public String out(String templateId, Object args) {

		try {
			Template template = configuration.getTemplate(templateId, "utf-8");
			StringWriter writer = new StringWriter();
			template.process(args, writer);
			return writer.toString();

		} catch (IOException | TemplateException e) {
			e.printStackTrace();
			return null;
		}
	}

}
