package com.mhdt.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

import com.mhdt.toolkit.Assert;

/**
 * 
 * @author LazyToShow <br>
 *         Date: Jan 31, 2019 <br>
 *         Time: 5:03:48 PM <br>
 */
public class SimpleRest implements Rest {

	Map<String, String> headers;

	Map<String, Object> paramers;

	String url;

	SimpleRest(String url) {
		this.url = url;
	}

	@Override
	public Rest addHeader(String key, String value) {

		Assert.notNull(key, "The header key is null");
		Assert.notNull(value, "The header value is null");

		if (headers == null)
			headers = new HashMap<>();

		headers.put(key, value);
		return this;
	}

	@Override
	public ByteWraps post() throws MalformedURLException, IOException {
		return Urls.request(url, RequestMethod.POST, paramers, headers, consumer);
	}

	@Override
	public ByteWraps delete() throws MalformedURLException, IOException {
		return Urls.request(url, RequestMethod.DELETE, paramers, headers, consumer);
	}

	@Override
	public ByteWraps put() throws MalformedURLException, IOException {
		return Urls.request(url, RequestMethod.PUT, paramers, headers, consumer);
	}

	@Override
	public ByteWraps get() throws MalformedURLException, IOException {
		return Urls.request(url, RequestMethod.GET, paramers, headers, consumer);
	}

	@Override
	public Rest addParamer(String key, String value) {

		if (paramers == null)
			paramers = new HashMap<>();

		paramers.put(key, value);
		return this;
	}

	@Override
	public Rest addParamer(Map<String, Object> paramers) {

		if (this.paramers == null)
			this.paramers = new HashMap<>();

		this.paramers.putAll(paramers);
		return this;
	}

	Consumer<HttpURLConnection> consumer;

	@Override
	public Rest configureLink(Consumer<HttpURLConnection> consumer) {
		this.consumer = consumer;
		return this;
	}

}
