/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.io;

import com.mhdt.degist.DegistTool;
import com.mhdt.toolkit.Assert;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileObservation
extends Observable {
    public File file;
    String md5;
    private static final FileCheck FILE_CHECK = new FileCheck();

    public FileObservation(File file) {
        Assert.notNull(file, "File is null");
        Assert.state(file.exists(), "File does not exist: " + file.getAbsolutePath());
        Assert.state(file.isFile(), "Not a legal file");
        this.file = file;
        this.md5 = DegistTool.md5(file);
        FILE_CHECK.add(this);
    }

    static class FileCheck
    extends Timer {
        List<FileObservation> fileObservations = new CopyOnWriteArrayList<FileObservation>();

        public FileCheck() {
            this.schedule(new TimerTask(){

                @Override
                public void run() {
                    fileObservations.forEach(fileObservation -> {
                        String newMd5 = DegistTool.md5(fileObservation.file);
                        if (!newMd5.equals(fileObservation.md5)) {
                            fileObservation.md5 = newMd5;
                            ((FileObservation)fileObservation).setChanged();
                            fileObservation.notifyObservers();
                        }
                    });
                }
            }, 2000L, 2000L);
        }

        void add(FileObservation fileObservation) {
            this.fileObservations.add(fileObservation);
        }
    }
}

