/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.dataStructure.cache;

import com.mhdt.dataStructure.cache.AbstractCache;
import java.util.HashMap;
import java.util.Iterator;

public class LFUCache<K, V>
extends AbstractCache<K, V> {
    LFUCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public LFUCache(int cacheSize, long defaultExpire) {
        super(cacheSize, defaultExpire);
        this.cacheMap = new HashMap(cacheSize + 1);
    }

    @Override
    protected int eliminateCache() {
        AbstractCache.CacheObject cacheObject;
        Iterator iterator = this.cacheMap.values().iterator();
        int count = 0;
        long minAccessCount = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            cacheObject = (AbstractCache.CacheObject)iterator.next();
            if (cacheObject.isExpired()) {
                iterator.remove();
                ++count;
                continue;
            }
            minAccessCount = Math.min(cacheObject.accessCount, minAccessCount);
        }
        if (count > 0) {
            return count;
        }
        if (minAccessCount != Long.MAX_VALUE) {
            iterator = this.cacheMap.values().iterator();
            while (iterator.hasNext()) {
                cacheObject = (AbstractCache.CacheObject)iterator.next();
                if (cacheObject.accessCount > minAccessCount) continue;
                iterator.remove();
                ++count;
            }
        }
        return count;
    }
}

