/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.dataStructure.cache;

import com.mhdt.dataStructure.cache.Cache;
import com.mhdt.toolkit.DateUtility;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final Lock writeLock = this.cacheLock.writeLock();
    protected Map<K, CacheObject<V>> cacheMap;
    protected int cacheSize;
    protected long defaultExpira;

    public AbstractCache(int cacheSize, long defaultExpirationTime) {
        this.cacheSize = cacheSize;
        this.defaultExpira = defaultExpirationTime;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.defaultExpira);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long survival) {
        this.writeLock.lock();
        try {
            CacheObject<V> co = new CacheObject<V>(value, survival);
            if (this.isFull()) {
                this.eliminate();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readLock.lock();
        try {
            CacheObject<V> entry = this.cacheMap.get(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            if (entry.isExpired()) {
                this.cacheMap.remove(key);
                V v = null;
                return v;
            }
            V v = entry.getObject();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int eliminate() {
        this.writeLock.lock();
        try {
            int n = this.eliminateCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract int eliminateCache();

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.cacheSize;
    }

    @Override
    public void remove(K key) {
        this.writeLock.lock();
        try {
            this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getDefaultExpire() {
        return this.defaultExpira;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    public String toString() {
        return "FIFOCache [cacheMap=" + this.cacheMap + " cacheSize=" + this.cacheSize + " defaultExpire=" + this.defaultExpira + "]";
    }

    class CacheObject<V> {
        final V value;
        long lastAccess;
        long accessCount;
        long expirationTime;

        CacheObject(V value, long ttl) {
            this.value = value;
            this.expirationTime = ttl;
            this.lastAccess = System.currentTimeMillis();
        }

        boolean isExpired() {
            if (this.expirationTime == 0L) {
                return false;
            }
            return this.lastAccess + this.expirationTime < System.currentTimeMillis();
        }

        V getObject() {
            this.lastAccess = System.currentTimeMillis();
            ++this.accessCount;
            return this.value;
        }

        public String toString() {
            return "value=" + this.value + ", lastAccess=" + DateUtility.intToString((int)this.lastAccess / 1000) + ", accessCount=" + this.accessCount + ", liveTime=" + this.expirationTime + "\n";
        }
    }
}

