/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.dataStructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class BinaryElement<T> {
    T root;
    BinaryElement<T> leftElement;
    BinaryElement<T> rightElement;

    public BinaryElement(T root) {
        this.root = root;
    }

    public void add(Comparator<T> comparator, T t) {
        if (this.root == null) {
            this.root = t;
            return;
        }
        if (comparator.compare(this.root, t) >= 0) {
            if (this.leftElement == null) {
                this.leftElement = new BinaryElement<T>(t);
            } else {
                this.leftElement.add(comparator, t);
            }
        } else if (this.rightElement == null) {
            this.rightElement = new BinaryElement<T>(t);
        } else {
            this.rightElement.add(comparator, t);
        }
    }

    public LinkedList<T> getList() {
        LinkedList list = new LinkedList();
        this.inorder(this, list);
        return list;
    }

    private void inorder(BinaryElement<T> element, List<T> list) {
        if (element != null) {
            this.inorder(element.leftElement, list);
            list.add(element.root);
            this.inorder(element.rightElement, list);
        }
    }

    public static void main(String[] args) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 100;
        BinaryElement.populate(BinaryElement.testDate(n), treeSet, list);
        long t0 = System.currentTimeMillis();
        Collections.sort(list);
        System.out.println("Collection\u6d4b\u8bd5\u6392\u5e8f" + n + "\u6761\u6570\u636e\u8017\u65f6:" + (System.currentTimeMillis() - t0) + "(\u6beb\u79d2)");
        t0 = System.currentTimeMillis();
        treeSet.toArray();
        System.out.println("\u4e8c\u53c9\u6811\u6d4b\u8bd5\u6392\u5e8f" + n + "\u6761\u6570\u636e\u8017\u65f6:" + (System.currentTimeMillis() - t0) + "(\u6beb\u79d2)");
    }

    private static void populate(int[] testDate, TreeSet<Integer> binaryTree, List<Integer> list) {
        for (int i : testDate) {
            binaryTree.add(i);
            list.add(i);
        }
    }

    private static int[] testDate(int n) {
        Random ran = new Random();
        int[] date = new int[n];
        for (int i = 0; i < n; ++i) {
            date[i] = ran.nextInt(100000000);
        }
        return date;
    }
}

