/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.analyse.Validate;
import com.mhdt.annotation.Alias;
import com.mhdt.annotation.BootStrapID;
import com.mhdt.annotation.NoDB;
import com.mhdt.annotation.Priority;
import com.mhdt.annotation.Table;
import com.mhdt.toolkit.ReflectionException;
import com.mhdt.toolkit.StringUtility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Reflect {
    static Map<Class<?>, String> cache = new HashMap();
    private static Map<Class<?>, Map<String, Method>> map = new HashMap();

    private Reflect() {
    }

    public static Field getField(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        return Reflect.getField(obj.getClass(), fieldName);
    }

    public static Field getField(Class<?> cls, String fieldName) {
        Field field;
        block6: {
            if (cls == null) {
                return null;
            }
            field = null;
            try {
                field = cls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                for (Field f : cls.getDeclaredFields()) {
                    if (!f.getName().toLowerCase().equals(fieldName.toLowerCase())) continue;
                    field = f;
                    break;
                }
                if (field != null) break block6;
                Class<?> c = cls.getSuperclass();
                if (c != null && c.getName().indexOf("java.lang.Object") != -1) {
                    return null;
                }
                field = Reflect.getField(c, fieldName);
            }
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getFieldByAlias(Object obj, String column) {
        Field[] fields;
        for (Field f : fields = Reflect.getFields(obj)) {
            if (!f.isAnnotationPresent(Alias.class) || !f.getAnnotation(Alias.class).value().equals(column)) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    public static Field[] getFields(Object bean) {
        if (bean == null) {
            throw new NullPointerException("Object is null");
        }
        return Reflect.getFields(bean.getClass());
    }

    public static Field[] getFields(Class<?> cls) {
        ArrayList<Field> result = new ArrayList<Field>();
        result.addAll(Arrays.asList(cls.getDeclaredFields()));
        while (!cls.getSuperclass().getSimpleName().equals("Object")) {
            cls = cls.getSuperclass();
            result.addAll(Arrays.asList(cls.getDeclaredFields()));
        }
        return result.toArray(new Field[0]);
    }

    public static Object getValue(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return Reflect.getField(obj, fieldName).get(obj);
    }

    public static Method getMethodByName(String cls, String methodName) throws ClassNotFoundException {
        return Reflect.getMethodByName(Class.forName(cls), methodName);
    }

    public static Method getMethodByName(Class<?> cls, String methodName) {
        Method[] methods = cls.getDeclaredMethods();
        while (methods != null && methods.length > 0) {
            for (Method method : methods) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
            if ((cls = cls.getSuperclass()) != null && cls.getName().indexOf("java.lang.Object") != -1) break;
            methods = cls.getDeclaredMethods();
        }
        return null;
    }

    public static Method getMethod(Object obj, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Class<?> c = obj.getClass();
        Method method = c.getMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] argClass = new Class[args.length];
        for (int i = 0; i < argClass.length; ++i) {
            argClass[i] = args[i].getClass();
        }
        Method method = owner.getClass().getDeclaredMethod(methodName, argClass);
        method.setAccessible(true);
        return method.invoke(owner, args);
    }

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Reflect.class.getClassLoader().loadClass(className).newInstance();
    }

    public static <T> T newInstance(String className, Class<T> cls) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (T)Reflect.class.getClassLoader().loadClass(className).newInstance();
    }

    public static Object newInstance(String className, Object ... args) throws Exception {
        Class<?> newoneClass = Reflect.class.getClassLoader().loadClass(className);
        Class[] argsClass = new Class[args.length];
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            argsClass[i] = args[i].getClass();
        }
        Constructor<?> cons = newoneClass.getDeclaredConstructor(argsClass);
        cons.setAccessible(true);
        return cons.newInstance(args);
    }

    public static Type[] getGeneric(Field field) {
        ParameterizedType type = (ParameterizedType)field.getGenericType();
        int size = type.getActualTypeArguments().length;
        if (size < 1) {
            return null;
        }
        return type.getActualTypeArguments();
    }

    public static <T> T[] newArray(Class<T> cls, int len) {
        return (Object[])Array.newInstance(cls, len);
    }

    public static void setField(Object obj, String fieldName, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = Reflect.getField(obj, fieldName);
        if (field == null) {
            throw new ReflectionException("Can't find field:" + fieldName + "  from " + obj.getClass());
        }
        field.setAccessible(true);
        value = Reflect.typeConversion(value, field.getType());
        field.set(obj, value);
    }

    public static Object typeConversion(Object value, Class<?> type) {
        String name = type.getName();
        if (name.equals("byte") || name.equals("Byte")) {
            return Byte.valueOf(value.toString());
        }
        if (name.equals("short") || name.equals("Short")) {
            return Short.valueOf(value.toString());
        }
        if (name.equals("float") || name.equals("Float")) {
            return Float.valueOf(value.toString());
        }
        if (name.equals("double") || name.equals("Double")) {
            return Double.valueOf(value.toString());
        }
        if (name.equals("int") || name.equals("Integer")) {
            return Integer.valueOf(value.toString());
        }
        if (name.equals("long") || name.equals("Long")) {
            return Long.valueOf(value.toString());
        }
        if (name.equals("boolean") || name.equals("Boolean")) {
            return Boolean.valueOf(value.toString());
        }
        if (name.equals("char") || name.equals("Character")) {
            return Character.valueOf(((Character)value).charValue());
        }
        return value;
    }

    public static Class<?> getClassOfHasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        boolean b = cls.isAnnotationPresent(annotation);
        if (b) {
            return cls;
        }
        if (!b && cls.getSuperclass() != null) {
            return Reflect.getClassOfHasAnnotation(cls.getSuperclass(), annotation);
        }
        return null;
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        boolean b = cls.isAnnotationPresent(annotation);
        if (!b && cls.getSuperclass() != null) {
            return Reflect.hasAnnotation(cls.getSuperclass(), annotation);
        }
        return b;
    }

    public static String getColumnValue(Field f) {
        return f.getAnnotation(Alias.class).value();
    }

    public static String getBootStrapId(Class<?> cls) {
        if (cache.containsKey(cls)) {
            return cache.get(cls);
        }
        if ((cls = Reflect.getClassOfHasAnnotation(cls, BootStrapID.class)) == null) {
            return null;
        }
        String result = cls.getAnnotation(BootStrapID.class).value();
        if (!Validate.isNullOrEmpty(result)) {
            cache.put(cls, result);
        }
        return result;
    }

    public static String getTableNameValue(Class<?> cls) {
        return (cls = Reflect.getClassOfHasAnnotation(cls, Table.class)) == null ? null : cls.getAnnotation(Table.class).value();
    }

    public static Type getGeneric(Class<?> cls) {
        return ((ParameterizedType)cls.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public static void setInject(Object target, String columnName, Object value) {
        Field f = Reflect.getField(target, columnName);
        f = f == null ? Reflect.getFieldByAlias(target, columnName) : f;
        try {
            if (f.isAnnotationPresent(NoDB.class)) {
                return;
            }
        }
        catch (NullPointerException e) {
            if (target.getClass().isAnnotationPresent(Priority.class)) {
                return;
            }
            throw new ReflectionException("Cant match field for '" + columnName + "' from " + target.getClass(), e);
        }
        try {
            Method method = Reflect.getSetMethod(target.getClass(), columnName);
            method.setAccessible(true);
            Class<?> paramerClass = method.getParameters()[0].getType();
            if (paramerClass.isEnum()) {
                value = Reflect.newEnum(paramerClass, String.valueOf(value));
            }
            method.invoke(target, value);
        }
        catch (Exception e) {
            try {
                f.setAccessible(true);
                f.set(target, value);
            }
            catch (Exception e1) {
                throw new ReflectionException(e1);
            }
        }
    }

    public static Method getSetMethod(Class<? extends Object> cls, String field) {
        String methodName = ("set" + field).toUpperCase();
        if (map.containsKey(cls) && map.get(cls).containsKey(methodName)) {
            return map.get(cls).get(methodName);
        }
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().toUpperCase().equals(methodName) || m.getParameterCount() != 1) continue;
            if (map.containsKey(cls)) {
                map.get(cls).put(methodName, m);
            } else {
                HashMap<String, Method> temp = new HashMap<String, Method>();
                temp.put(methodName, m);
                map.put(cls, temp);
            }
            return m;
        }
        return null;
    }

    public static Object getInject(Object target, String field) {
        Field f = Reflect.getField(target, field);
        f = f == null ? Reflect.getFieldByAlias(target, field) : f;
        try {
            Method method = target.getClass().getDeclaredMethod("get" + StringUtility.firstToUpperCase(field), new Class[0]);
            return method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            try {
                f.setAccessible(true);
                return f.get(target);
            }
            catch (Exception e1) {
                throw new ReflectionException(e1);
            }
        }
    }

    public static <T> T newInstance(Class<T> type) throws InstantiationException, IllegalAccessException {
        return type.newInstance();
    }

    public static <T> T newEnum(Class<T> cls, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = Reflect.getMethodByName(cls, "valueOf");
        return (T)method.invoke(cls, value);
    }
}

