/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.Print;
import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Assert;
import com.mhdt.toolkit.PathUtil;
import com.mhdt.toolkit.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class FileUtility {
    private FileUtility() {
    }

    public static File buider(String path) {
        if (path.startsWith("classpath:")) {
            try {
                String temp = path.substring(path.indexOf("classpath:") + 10);
                URI uri = FileUtility.class.getResource(File.separator + temp).toURI();
                return new File(uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (path.startsWith("file:")) {
            return new File(new File(PathUtil.underCurrentProject() + path.substring(path.indexOf("file:") + 5)).getAbsolutePath());
        }
        return new File(path);
    }

    public static File randomFileName(File folder) {
        File[] files = folder.listFiles();
        Random r = new Random();
        return files[r.nextInt(files.length)];
    }

    public static void remove(String path) {
        FileUtility.remove(new File(path));
    }

    public static boolean remove(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return file.delete();
            }
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtility.remove(files[i]);
                }
                return file.delete();
            }
        }
        return false;
    }

    public static void removeByPrefix(File folder, String startWith) {
        for (File file : folder.listFiles()) {
            if (!file.getName().startsWith(startWith)) continue;
            FileUtility.remove(file);
        }
    }

    public static void removeBySuffix(File folder, String endwith) {
        for (File file : folder.listFiles()) {
            if (!file.getName().endsWith(endwith)) continue;
            FileUtility.remove(file);
        }
    }

    public static String getFormat(File file) {
        Assert.notNull(file, "File is null");
        if (!file.exists() || file.getName().indexOf(".") == -1) {
            return null;
        }
        return file.getName().substring(file.getName().lastIndexOf(".") + 1);
    }

    public static String getFormat(String fileName) {
        Assert.notNullOrEmpty(fileName, "fileName is null or empty");
        Assert.state(fileName.contains("."), "Unformatted file, File name not included '.'");
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static boolean createFloder(File floder) {
        boolean flag = true;
        if (!floder.exists()) {
            try {
                flag = floder.mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
                flag = false;
            }
        }
        return flag;
    }

    public static boolean createFile(File file) {
        Assert.notNull(file, "File is null");
        if (!file.exists()) {
            try {
                File floder;
                if (!Validate.isNullOrEmpty(file.getParent()) && !(floder = new File(file.getParent())).exists()) {
                    FileUtility.createFloder(floder);
                }
                return file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static String lastDirectory(File file) {
        Assert.notNull(file, "File is null");
        return file.getParent();
    }

    public static boolean rename(File file, String name) {
        Assert.notNull(file, "File is null");
        Assert.notNullOrEmpty(name, "Name is null or empty");
        Assert.state(file != null && file.exists(), "File does not exist " + file == null ? "" : file.getAbsolutePath());
        if (file.isDirectory()) {
            return file.renameTo(new File(FileUtility.lastDirectory(file) + File.separator + name));
        }
        if (file.isFile()) {
            String format = FileUtility.getFormat(file);
            File newFile = null;
            newFile = Validate.isNullOrEmpty(format) || name.endsWith("." + format) ? new File(FileUtility.lastDirectory(file) + File.separator + name) : new File(FileUtility.lastDirectory(file) + File.separator + name + "." + format);
            return file.renameTo(newFile);
        }
        return false;
    }

    public static boolean shear(File source, File dest, FileType destFileType) {
        if (source == null || !source.exists()) {
            throw new NullPointerException("\u6e90\u6587\u4ef6[source]\u4e3a 'Null' \u6216 \u4e0d\u5b58\u5728");
        }
        if (source.isDirectory()) {
            return FileUtility.shearFolder(source, dest, destFileType);
        }
        if (source.isFile()) {
            return FileUtility.shearFile(source, dest, destFileType);
        }
        return false;
    }

    private static boolean shearFolder(File src, File dest, FileType destFileType) {
        if (destFileType != FileType.Directory) {
            Print.error("\u526a\u5207\u6587\u4ef6\u5939: \u76ee\u6807\u6587\u4ef6[dest]\u4e5f\u5fc5\u987b\u662f\u6587\u4ef6\u5939");
            return false;
        }
        dest = new File(dest.getAbsoluteFile() + "/" + src.getName());
        FileUtility.createFloder(dest);
        File[] files = src.listFiles();
        if (files.length > 0) {
            for (File temp : files) {
                File n = new File(dest.getAbsolutePath() + "/" + temp.getName());
                if (!FileUtility.copyFile(temp, n) || !temp.exists()) continue;
                temp.delete();
            }
        }
        src.delete();
        return true;
    }

    private static boolean shearFile(File src, File dest, FileType destFileType) {
        if (destFileType == FileType.File) {
            FileUtility.createFloder(new File(FileUtility.lastDirectory(dest)));
            if (FileUtility.copyFile(src, dest)) {
                src.delete();
                return true;
            }
            return false;
        }
        if (destFileType == FileType.Directory) {
            FileUtility.createFloder(dest);
            if (FileUtility.copyFile(src, new File(dest.getAbsolutePath() + "/" + src.getName()))) {
                src.delete();
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean copy(File src, File dest, FileType destFileType) {
        if (src.isFile()) {
            if (destFileType == FileType.Directory) {
                dest = new File(dest.getAbsoluteFile() + "/" + src.getName());
            }
            FileUtility.createFile(dest);
            return FileUtility.copyFile(src, dest);
        }
        if (src.isDirectory()) {
            if (destFileType == FileType.File) {
                Print.error("\u590d\u5236\u6587\u4ef6\u5939-\u5931\u8d25, \u56e0\u4e3a: \u51fa\u4e8e\u6b67\u4e49\u7684\u8003\u8651(\u590d\u5236\u6587\u4ef6\u5939\u5230\u6587\u4ef6 ??) - \u8bf7\u5c06\u6587\u4ef6\u5939\u4f5c\u4e3a\u8f93\u51fa\u9879[dest]");
                return false;
            }
            return FileUtility.copyFolder(src, dest);
        }
        return false;
    }

    private static boolean copyFolder(File src, File dest) {
        try {
            File[] files;
            dest = new File(dest.getAbsoluteFile() + "/" + src.getName());
            FileUtility.createFloder(dest);
            for (File file : files = src.listFiles()) {
                FileUtility.copyFile(file, new File(dest.getAbsoluteFile() + "/" + file.getName()));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File src, File dest) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            in = fis.getChannel();
            out = fos.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fis.close();
                in.close();
                fos.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getPureName(File file) {
        if (file == null || !file.exists()) {
            throw new NullPointerException("\u6587\u4ef6\u4e3a\u7a7a:" + file.getAbsolutePath());
        }
        String name = file.getName();
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static String getPureName(String fileName) {
        Assert.notNullOrEmpty(fileName, "fileName is null or empty");
        if (fileName.contains(".")) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static List<String> childies(File folder) {
        return FileUtility.childies(folder, null);
    }

    public static List<String> childies(File folder, String $suffix) {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        List<File> fs = Arrays.asList(folder.listFiles());
        Collections.sort(fs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                try {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    return StringUtility.extractInteger(name1) - StringUtility.extractInteger(name2);
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        for (File f : fs) {
            if (Validate.isNullOrEmpty($suffix) || !f.getAbsolutePath().endsWith($suffix)) continue;
            list.add(f.getAbsolutePath());
        }
        return list;
    }

    public static File[] findByPrefix(File folder, Object prefix) {
        ArrayList<File> list = new ArrayList<File>();
        String preName = prefix.toString();
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(Arrays.asList(FileUtility.findByPrefix(file, prefix)));
                continue;
            }
            if (!file.isFile() || !file.getName().startsWith(preName)) continue;
            list.add(file);
        }
        return list.toArray(new File[1]);
    }

    public static File join(File foleder, String fileName) {
        return new File(foleder.getAbsolutePath() + File.separator + fileName);
    }

    public static enum FileType {
        File,
        Directory;

    }
}

