/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.scheduler;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CompositeScheduler
implements Runnable {
    protected ExecutorService service;
    protected static final int core_thread = Runtime.getRuntime().availableProcessors() * 2;
    private Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    protected int maxThreadCount;
    private AtomicBoolean atomicBoolean = new AtomicBoolean();

    CompositeScheduler() {
        this.service = Executors.newFixedThreadPool(core_thread);
    }

    final CompositeScheduler scheduler(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount > 0 ? maxThreadCount : 1;
        this.service = Executors.newFixedThreadPool(this.maxThreadCount);
        return this;
    }

    public final boolean registed(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        if (this.service.isTerminated()) {
            throw new RuntimeException("The moment can't registed - \" this scheduler already shutDown.\"");
        }
        return this.queue.add(runnable);
    }

    private final Runnable getTask() {
        if (this.queue != null && !this.queue.isEmpty()) {
            return this.queue.poll();
        }
        return null;
    }

    final void singleExecute() {
        this.checkService();
        this.service.execute(this);
    }

    private final void checkService() {
        if (this.service == null || this.service.isTerminated()) {
            this.service = Executors.newFixedThreadPool(this.maxThreadCount);
        }
    }

    final void multiExcute() {
        this.checkService();
        new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    Runnable runnable;
                    if ((runnable = CompositeScheduler.this.getTask()) != null) {
                        CompositeScheduler.this.service.execute(runnable);
                        continue;
                    }
                    CompositeScheduler.this.sleep(100L);
                } while (!CompositeScheduler.this.service.isTerminated());
            }
        }).start();
        this.atomicBoolean.compareAndSet(false, true);
    }

    @Override
    public void run() {
        while (true) {
            Runnable runnable;
            if ((runnable = this.getTask()) != null) {
                runnable.run();
                continue;
            }
            this.sleep(1000L);
        }
    }

    public void waitAndShutDown() {
        this.sleep(1000L);
        boolean flag = this.atomicBoolean.get();
        if (!flag) {
            return;
        }
        this.atomicBoolean.compareAndSet(true, false);
        this.service.shutdown();
        while (!this.service.isTerminated()) {
            this.sleep(2000L);
        }
    }

    private final void sleep(long timelong) {
        try {
            Thread.sleep(timelong);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }
}

