/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.parse;

import com.mhdt.analyse.Validate;
import com.mhdt.io.FileIO;
import com.mhdt.toolkit.Assert;
import com.mhdt.toolkit.StringUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Properties {
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public final void load(InputStream is) throws IOException {
        this.populate(FileIO.getContent(is).split("\r\n"));
    }

    public final void load(InputStream is, String encode) throws IOException {
        this.populate(FileIO.getContent(is, encode).split("\r\n"));
    }

    public final void load(File file) throws IOException {
        this.load(file, "utf-8");
    }

    public final void load(File file, String encode) throws IOException {
        String[] arrays = FileIO.getContent(file, encode).split("\r\n");
        this.populate(arrays);
    }

    public final void load(String path) throws IOException {
        this.populate(FileIO.getContent(path).split("\r\n"));
    }

    public final void load(String path, String encode) throws IOException {
        this.populate(FileIO.getContent(path, encode).split("\r\n"));
    }

    private void populate(String[] arrays) {
        this.map.clear();
        for (String content : arrays) {
            if ((content = StringUtility.removeBlankChar(content)).startsWith("#") || Validate.isNullOrEmpty(content) || content.indexOf("=") == -1) continue;
            String[] array = new String[2];
            int flag = content.indexOf("=");
            array[0] = content.substring(0, flag).toLowerCase();
            array[1] = content.substring(flag + 1);
            if (Validate.isNullOrEmpty(array[0])) continue;
            this.map.put(StringUtility.removeBlankChar(array[0]), StringUtility.removeBlankChar(array[1]));
        }
    }

    public boolean containsKey(String key) {
        if (Validate.isNullOrEmpty(key)) {
            return false;
        }
        return this.map.containsKey(key.toLowerCase());
    }

    public boolean containsValue(String value) {
        if (Validate.isNullOrEmpty(value)) {
            return false;
        }
        return this.map.containsValue(value);
    }

    public void clear() {
        this.map.clear();
    }

    public final String get(String key) {
        return (String)this.map.get(key.toLowerCase());
    }

    public final Integer getInteger(String key) throws NumberFormatException {
        return Validate.isNullOrEmpty(this.map.get(key.toLowerCase())) ? null : Integer.valueOf(Integer.parseInt(this.map.get(key.toLowerCase()).toString()));
    }

    public final Double getDouble(String key) {
        return Validate.isNullOrEmpty(this.map.get(key.toLowerCase())) ? null : Double.valueOf(Double.parseDouble(this.map.get(key.toLowerCase()).toString()));
    }

    public Long getLong(String key) {
        return Validate.isNullOrEmpty(this.map.get(key.toLowerCase())) ? null : Long.valueOf(Long.parseLong(this.map.get(key.toLowerCase()).toString()));
    }

    public final Boolean getBoolean(String key) {
        return Validate.isNullOrEmpty(this.map.get(key.toLowerCase())) ? null : Boolean.valueOf(Boolean.parseBoolean(this.map.get(key.toLowerCase()).toString()));
    }

    public final Set<String> getKeys() {
        Iterator<String> it = new HashSet<String>(this.map.keySet()).iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith("aNnOtAtIoN_")) continue;
            it.remove();
        }
        return this.map.keySet();
    }

    public final synchronized Object remove(String key) {
        if (key == null) {
            throw new NullPointerException("The key should be not null.");
        }
        return this.map.remove(key.toLowerCase());
    }

    public final synchronized void put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("The key should be not null.");
        }
        this.map.put(key.toLowerCase(), value);
    }

    public final synchronized void put(Map.Entry<String, Object> entry) {
        if (entry == null) {
            throw new NullPointerException("Entry is null.");
        }
        this.map.put(entry.getKey().toLowerCase(), entry.getValue());
    }

    public final synchronized void putAnnotation(Object content) {
        if (Validate.isNullOrEmpty(content)) {
            throw new NullPointerException("The content must be not null . ");
        }
        this.map.put("aNnOtAtIoN_" + System.nanoTime(), content);
    }

    public final void save(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (entry.getKey().startsWith("aNnOtAtIoN_")) {
                stringBuilder.append("# " + entry.getValue() + "\r\n");
                continue;
            }
            stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "\r\n");
        }
        FileIO.write(file, stringBuilder.toString().substring(0, stringBuilder.length() - "\r\n".length()), false);
    }

    public final Map<String, Object> map() {
        return this.map;
    }

    public final Collection<Object> values() {
        return this.map.values();
    }

    public final List<String> sortByKey() {
        ArrayList<String> list1 = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.map().entrySet()) {
            list1.add(entry.getKey() + "=" + entry.getValue());
        }
        Collections.sort(list1);
        return list1;
    }

    public final List<String> sortByValue() {
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.map().entrySet()) {
            list1.add(entry.getValue() + "=" + entry.getKey());
        }
        Collections.sort(list1);
        for (String temp : list1) {
            list2.add(temp.split("=")[1] + "=" + temp.split("=")[0]);
        }
        return list2;
    }

    public java.util.Properties toJavaPropertie() {
        java.util.Properties properties = new java.util.Properties();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public Properties screening(String prefix) {
        Assert.notNull(prefix, "prefix is null");
        Assert.state(prefix.indexOf(".") == -1, "The prefix: '" + prefix + "' format is incorrect. Because contain '.' ");
        Properties properties = new Properties();
        prefix = prefix + ".";
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            properties.put(entry.getKey().substring(entry.getKey().indexOf(prefix) + prefix.length()), entry.getValue());
        }
        return properties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("+--------+---------------+---------------------+-----+\r\n");
        sb.append("|----------------     properties     ----------------+\r\n");
        for (Map.Entry<String, Object> en : this.map.entrySet()) {
            sb.append("|      [ '" + en.getKey() + "'=" + en.getValue() + "] \r\n");
        }
        sb.append("|--------------    /properties     ------------------ \r\n");
        sb.append("+--------+---------------+---------------------+-----+ \r\n");
        return sb.toString();
    }
}

