/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.parse;

import com.mhdt.Print;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AppclassLoad {
    public void loadJars(File source) {
        File[] files;
        if (source == null || !source.exists() || source.isFile()) {
            return;
        }
        for (File jar : files = source.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        })) {
            this.load(jar);
        }
    }

    public List<String> loadClasses(File folder) throws Exception {
        if (folder == null) {
            return null;
        }
        int root_len = folder.getAbsolutePath().length();
        if (folder.exists() && folder.isDirectory()) {
            this.load(folder);
            return this.populateClassName(folder, root_len);
        }
        return null;
    }

    private List<String> populateClassName(File source, int root_len) {
        ArrayList<String> list = new ArrayList<String>();
        Stack<File> stack = new Stack<File>();
        stack.push(source);
        while (!stack.isEmpty()) {
            File parent = (File)stack.pop();
            for (File child : this.getChilds(parent)) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                list.add(child.getAbsolutePath().substring(root_len + 1, child.getAbsolutePath().length() - 6).replace("\\", "."));
            }
        }
        return list;
    }

    private File[] getChilds(File parent) {
        return parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory() || child.getName().endsWith(".class");
            }
        });
    }

    private void load(File folder) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            URL url = folder.toURI().toURL();
            Print.info(url);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> getClassName(String packageName, boolean childPackage) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        Enumeration<URL> urls = loader.getResources(URLDecoder.decode(packagePath, "UTF-8"));
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames.addAll(AppclassLoad.getClassNameByFile(url.getPath(), childPackage));
                continue;
            }
            if (!type.equals("jar")) continue;
            fileNames.addAll(AppclassLoad.getClassNameByJar(url.getPath(), childPackage));
        }
        fileNames.addAll(AppclassLoad.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage));
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        File[] childFiles = file.listFiles();
        if (childFiles == null) {
            return myClassName;
        }
        for (File childFile : childFiles) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(AppclassLoad.getClassNameByFile(childFile.getPath(), childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf(File.separator + "classes" + File.separator) + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace(File.separator, ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(URLDecoder.decode(jarFilePath, "utf-8"));
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(AppclassLoad.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

