/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.StringUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RequestResult {
    String status;
    String message = "";
    Map<String, Object> data = new HashMap<String, Object>();
    String jsonData;
    String stackMessage = "";

    private RequestResult() {
    }

    private static RequestResult status(Status status) {
        RequestResult result = new RequestResult();
        result.status = status.value;
        return result;
    }

    public static RequestResult successBuid() {
        return RequestResult.status(Status.SUCCESS);
    }

    public static RequestResult faildBuid() {
        return RequestResult.status(Status.FAILD);
    }

    public static RequestResult faildBuid(String message) {
        RequestResult requestResult = RequestResult.faildBuid();
        requestResult.setMessage(message);
        return requestResult;
    }

    public static RequestResult faildBuid(Throwable throwable) {
        RequestResult requestResult = RequestResult.faildBuid(throwable.getMessage());
        requestResult.setStackMessage(StringUtility.getStackMessage(throwable));
        return requestResult;
    }

    public String getStringFromJson(String key) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return null;
        }
        return JSON.parseObject((String)this.jsonData).getString(key);
    }

    public static RequestResult parse(byte[] bytes) {
        RequestResult requestResult = new RequestResult();
        JSONObject object = JSON.parseObject((String)new String(bytes));
        requestResult.status = object.getString("status");
        requestResult.message = object.getString("message");
        requestResult.jsonData = object.getString("data");
        return requestResult;
    }

    public static RequestResult perform(Consumer<RequestResult> consumer) {
        RequestResult result = new RequestResult();
        try {
            result.status = Status.SUCCESS.value;
            consumer.accept(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.faild(e);
        }
        return result;
    }

    public RequestResult message(String message) {
        this.message = message;
        return this;
    }

    public RequestResult stackMessage(String stackMessage) {
        this.stackMessage = stackMessage;
        return this;
    }

    public RequestResult put(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public Integer getIntFromJson(String key) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return null;
        }
        return JSON.parseObject((String)this.jsonData).getIntValue(key);
    }

    public <T> T getObjectFromJson(String key, Class<T> cls) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return null;
        }
        return (T)JSON.parseObject((String)JSON.parseObject((String)this.jsonData).getString(key), cls);
    }

    public <T> List<T> getListFromJson(String key, Class<T> cls) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return new ArrayList();
        }
        ArrayList list = JSON.parseArray((String)JSON.parseObject((String)this.jsonData).getString(key), cls);
        if (list.size() == 1 && list.get(0) == null) {
            list = new ArrayList();
        }
        return list;
    }

    public String getStackMessage() {
        return this.stackMessage;
    }

    public void setStackMessage(String stackMessage) {
        this.stackMessage = stackMessage;
    }

    public void putAttribute(Map<String, Object> atttibuters) {
        this.data.putAll(atttibuters);
    }

    public void faild(String message) {
        this.setStatus(Status.FAILD.value);
        this.setMessage(message);
    }

    public void faild(Throwable e) {
        this.faild(e.getMessage());
        this.setStackMessage(StringUtility.getStackMessage(e));
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static enum Status {
        SUCCESS("success"),
        FAILD("faild");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

