/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.imageEditor;

import com.mhdt.imageEditor.FastGaussianBlurFilter;
import com.mhdt.imageEditor.GaussianFilter;
import com.mhdt.toolkit.ImageUtility;
import java.awt.image.BufferedImage;

public class StackGaussianBlurFilter
extends GaussianFilter {
    private final int radius;
    private final int iterations;

    public StackGaussianBlurFilter() {
        this(3, 3);
    }

    public StackGaussianBlurFilter(int radius) {
        this(radius, 3);
    }

    public StackGaussianBlurFilter(int radius, int iterations) {
        if (radius < 1) {
            radius = 1;
        }
        if (iterations < 1) {
            iterations = 1;
        }
        this.radius = radius;
        this.iterations = iterations;
    }

    public int getEffectiveRadius() {
        return this.getIterations() * this.getRadius();
    }

    public int getRadius() {
        return this.radius;
    }

    public int getIterations() {
        return this.iterations;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        ImageUtility.getPixels(src, 0, 0, width, height, srcPixels);
        for (int i = 0; i < this.iterations; ++i) {
            FastGaussianBlurFilter.blur(srcPixels, dstPixels, width, height, this.radius);
            FastGaussianBlurFilter.blur(dstPixels, srcPixels, height, width, this.radius);
        }
        ImageUtility.setPixels(dest, 0, 0, width, height, srcPixels);
        return dest;
    }
}

