/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.imageEditor;

import com.mhdt.imageEditor.GaussianFilter;
import com.mhdt.toolkit.ImageUtility;
import java.awt.image.BufferedImage;

public class FastGaussianBlurFilter
extends GaussianFilter {
    private final int radius;

    public FastGaussianBlurFilter() {
        this(3);
    }

    public FastGaussianBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        ImageUtility.getPixels(src, 0, 0, width, height, srcPixels);
        FastGaussianBlurFilter.blur(srcPixels, dstPixels, width, height, this.radius);
        FastGaussianBlurFilter.blur(dstPixels, srcPixels, height, width, this.radius);
        ImageUtility.setPixels(dest, 0, 0, width, height, srcPixels);
        return dest;
    }

    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, int radius) {
        int i;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        int srcIndex = 0;
        int[] sumLookupTable = new int[256 * windowSize];
        for (int i2 = 0; i2 < sumLookupTable.length; ++i2) {
            sumLookupTable[i2] = i2 / windowSize;
        }
        int[] indexLookupTable = new int[radiusPlusOne];
        if (radius < width) {
            for (i = 0; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = i;
            }
        } else {
            for (i = 0; i < width; ++i) {
                indexLookupTable[i] = i;
            }
            for (i = width; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = width - 1;
            }
        }
        for (int y = 0; y < height; ++y) {
            int sumBlue = 0;
            int sumGreen = 0;
            int sumRed = 0;
            int sumAlpha = 0;
            int dstIndex = y;
            int pixel = srcPixels[srcIndex];
            sumAlpha += radiusPlusOne * (pixel >> 24 & 0xFF);
            sumRed += radiusPlusOne * (pixel >> 16 & 0xFF);
            sumGreen += radiusPlusOne * (pixel >> 8 & 0xFF);
            sumBlue += radiusPlusOne * (pixel & 0xFF);
            for (int i3 = 1; i3 <= radius; ++i3) {
                pixel = srcPixels[srcIndex + indexLookupTable[i3]];
                sumAlpha += pixel >> 24 & 0xFF;
                sumRed += pixel >> 16 & 0xFF;
                sumGreen += pixel >> 8 & 0xFF;
                sumBlue += pixel & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int previousPixelIndex;
                dstPixels[dstIndex] = sumLookupTable[sumAlpha] << 24 | sumLookupTable[sumRed] << 16 | sumLookupTable[sumGreen] << 8 | sumLookupTable[sumBlue];
                dstIndex += height;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[srcIndex + nextPixelIndex];
                int previousPixel = srcPixels[srcIndex + previousPixelIndex];
                sumAlpha += nextPixel >> 24 & 0xFF;
                sumAlpha -= previousPixel >> 24 & 0xFF;
                sumRed += nextPixel >> 16 & 0xFF;
                sumRed -= previousPixel >> 16 & 0xFF;
                sumGreen += nextPixel >> 8 & 0xFF;
                sumGreen -= previousPixel >> 8 & 0xFF;
                sumBlue += nextPixel & 0xFF;
                sumBlue -= previousPixel & 0xFF;
            }
            srcIndex += width;
        }
    }
}

