/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.analyse.Validate;
import com.mhdt.io.RandomAcessInputStream;
import com.mhdt.toolkit.Assert;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtility {
    private static final String[][] brackets;
    private static Map<Character, Integer> units;
    private static Map<Character, Character> values;
    private static Map<Character, Character> arab_format;
    private static Map<Character, Character> english_format;

    private StringUtility() {
    }

    public static int indexOf(String content, String pattern) {
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (!Pattern.matches(pattern, c + "")) continue;
            return i;
        }
        return -1;
    }

    public static final String encode(String str, String encode) {
        if (Validate.isNullOrEmpty(str)) {
            return null;
        }
        try {
            return URLEncoder.encode(str, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String decode(String str, String encode) {
        if (Validate.isNullOrEmpty(str)) {
            return null;
        }
        try {
            return URLDecoder.decode(str, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String removeBlankChar(String txt) {
        char val;
        int st;
        if (txt == null || txt.trim().length() < 1) {
            return txt;
        }
        int len = txt.length();
        for (st = 0; st < len && Validate.isBlank(val = txt.charAt(st)); ++st) {
        }
        while (st < len && Validate.isBlank(val = txt.charAt(len - 1))) {
            --len;
        }
        if (st > 0 || len < txt.length()) {
            txt = txt.substring(st, len);
        }
        return txt;
    }

    public static String checkBrackets(String str) {
        if (Validate.isNullOrEmpty(str)) {
            return str;
        }
        for (String[] bracket : brackets) {
            if (str.indexOf(bracket[0]) == -1 || str.indexOf(bracket[1]) != -1) continue;
            str = str.substring(str.indexOf(bracket[0]) + 1);
        }
        for (String[] bracket : brackets) {
            int start = 0;
            int end = 0;
            start = str.indexOf(bracket[0]);
            if (start == -1 || (end = str.indexOf(bracket[1])) == -1 || start <= end) continue;
            str = str.substring(0, end);
        }
        for (String[] bracket : brackets) {
            int index = str.indexOf(bracket[0]);
            if (index <= -1 || str.indexOf(bracket[1]) <= str.indexOf(bracket[0], index + 1) || str.indexOf(bracket[1], str.indexOf(bracket[1]) + 1) != -1) continue;
            str = str.substring(index + 1);
        }
        return str;
    }

    public static String extractNumbers(String content) {
        if (Validate.isNullOrEmpty(content)) {
            return content;
        }
        content = StringUtility.formatArabNumber(content);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (!Validate.isNum(c)) continue;
            sb.append(c);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static Integer extractInteger(String content) {
        if (Validate.isNullOrEmpty(content)) {
            return null;
        }
        String temp = StringUtility.extractNumbers(content);
        if (!Validate.isNullOrEmpty(temp) && temp.startsWith("0")) {
            temp.replaceFirst("0", "");
        }
        if (!Validate.isNullOrEmpty(temp)) {
            return Integer.parseInt(temp);
        }
        return null;
    }

    public static String extractPhone(String content) {
        if (content.length() < 11) {
            return null;
        }
        Matcher matcher = Validate.pattern_PHONE.matcher(content);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String extractTelephone(String content) {
        if (content.length() < 7) {
            return null;
        }
        Matcher matcher = Pattern.compile("((0\\d{2,3}|852|853)[-\u2014]?[2-8]\\d{6,7})").matcher(content);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String formatArabNumber(String number) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (arab_format.containsKey(Character.valueOf(c))) {
                sb.append(arab_format.get(Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String parseNumber(String content) {
        StringBuilder str = new StringBuilder();
        StringBuilder number = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (Validate.isNum(c) || units.containsKey(Character.valueOf(c)) || values.containsKey(Character.valueOf(c)) || c == '.' && number.length() > 0 && StringUtility.contains(number.toString(), '.') == 0) {
                if (number.length() == 0 && c == '0' | c == '\u96f6' && (content.length() <= i + 2 || content.charAt(i + 1) != '.')) {
                    str.append(0);
                    continue;
                }
                number.append(c);
                continue;
            }
            if (number.length() > 0) {
                boolean appPoint = false;
                if (number.toString().endsWith(".")) {
                    number.replace(number.length() - 1, number.length(), "");
                    appPoint = true;
                }
                if (number.length() > 15) {
                    str.append(number.toString());
                } else {
                    double d = StringUtility.parseNum(number.toString());
                    str.append((d + "").endsWith(".0") ? new BigDecimal(d) : new BigDecimal((long)d));
                    if (appPoint) {
                        str.append(".");
                    }
                }
                number.setLength(0);
            }
            str.append(c);
        }
        if (number.length() > 0) {
            boolean appPoint = false;
            if (number.toString().endsWith(".")) {
                number.replace(number.length() - 1, number.length(), "");
                appPoint = true;
            }
            if (number.length() > 15) {
                str.append(number.toString());
            } else {
                double d = StringUtility.parseNum(number.toString());
                str.append((d + "").endsWith(".0") ? new BigDecimal(d) : new BigDecimal((long)d));
                if (appPoint) {
                    str.append(".");
                }
            }
        }
        return str.toString();
    }

    private static double parseNum(String number) {
        StringBuilder num = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '\u96f6') {
                num.append(0);
                continue;
            }
            if (c == '\u5341' || c == '\u62fe') {
                if (i == 0) {
                    if (number.length() > 1 && (Validate.isNum(number.charAt(i + 1)) || values.containsKey(Character.valueOf(number.charAt(i + 1))))) {
                        num.append("1");
                        continue;
                    }
                    num.append("10");
                    continue;
                }
                if (i == number.length() - 1 || i > 0 && i < number.length() - 1 && !values.containsKey(Character.valueOf(number.charAt(i + 1)))) {
                    num.append("0");
                    continue;
                }
                if (i <= 0 || i >= number.length() - 1 || !values.containsKey(Character.valueOf(number.charAt(i + 1))) || values.containsKey(Character.valueOf(number.charAt(i - 1)))) continue;
                num.append("1");
                continue;
            }
            if (values.containsKey(Character.valueOf(c))) {
                num.append(values.get(Character.valueOf(c)));
                continue;
            }
            num.append(c);
        }
        number = num.toString();
        num = new StringBuilder();
        char lastUnit = '\u96f6';
        double result = 0.0;
        double max = 0.0;
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (Validate.isNum(c) || c == '.' && i > 0 && num.length() > 0) {
                if (i == number.length() - 1 && num.length() < 1 && units.get(Character.valueOf(lastUnit)) / 10 >= 10) {
                    num.append(units.get(Character.valueOf(lastUnit)) / 10 * Integer.parseInt(c + ""));
                } else {
                    num.append(c);
                }
                if (i != number.length() - 1) continue;
                String figure = num.toString();
                if (StringUtility.contains(figure, '.') > 1) break;
                if (figure.endsWith(".")) {
                    figure = figure.substring(0, figure.length() - 1);
                }
                result += Double.parseDouble(figure);
                break;
            }
            if (!units.containsKey(Character.valueOf(c))) continue;
            if (i == 0) {
                result = units.get(Character.valueOf(c)).intValue();
                if (c == '\u4ebf') {
                    max = result;
                    result = 0.0;
                    num.setLength(0);
                    continue;
                }
                lastUnit = c;
            }
            if (i > 0 && i < number.length() - 1) {
                if (num.length() == 0) {
                    num.append(0);
                }
                double d = result = units.get(Character.valueOf(c)) < units.get(Character.valueOf(lastUnit)) ? result + Double.parseDouble(num.toString()) * (double)units.get(Character.valueOf(c)).intValue() : (result + Double.parseDouble(num.toString())) * (double)units.get(Character.valueOf(c)).intValue();
                if (c == '\u4ebf') {
                    max = result;
                    result = 0.0;
                    num.setLength(0);
                    continue;
                }
                lastUnit = c;
                num.setLength(0);
                continue;
            }
            if (i != number.length() - 1) continue;
            if (units.get(Character.valueOf(c)) > units.get(Character.valueOf(lastUnit))) {
                if (num.length() > 0) {
                    result += Double.parseDouble(num.toString());
                }
                result = result == 0.0 ? (double)(1 * units.get(Character.valueOf(c))) : result * (double)units.get(Character.valueOf(c)).intValue();
                continue;
            }
            if (!units.containsKey(Character.valueOf(c)) || units.get(Character.valueOf(c)) == units.get(Character.valueOf(lastUnit)) || num.length() <= 0) continue;
            result += Double.parseDouble(num.toString()) * (double)units.get(Character.valueOf(c)).intValue();
        }
        return max + result;
    }

    public static int contains(String source, char c) {
        return StringUtility.contains(source, String.valueOf(c));
    }

    public static int contains(String source, String matchStr) {
        if (source == null || matchStr == null) {
            throw new NullPointerException(" Source or matchStr is null.");
        }
        int index = -1;
        int count = 0;
        while ((index = source.indexOf(matchStr, index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    public static String formatEnglish(String content) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (english_format.containsKey(Character.valueOf(c))) {
                sb.append(english_format.get(Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toString(InputStream in) {
        return StringUtility.toString(in, "utf-8");
    }

    public static String toString(InputStream in, String charsetName) {
        try {
            if (in == null) {
                return null;
            }
            RandomAcessInputStream ran = new RandomAcessInputStream(in);
            byte[] bytes = new byte[ran.available()];
            ran.read(bytes);
            ran.close();
            return new String(bytes, charsetName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String doubleToString(double d) {
        return new DecimalFormat("#.00").format(d);
    }

    public static String capitalizeFirstLetter(String name) {
        if (Validate.isNullOrEmpty(name)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        String c = String.valueOf(sb.charAt(0));
        return sb.replace(0, 1, c.toUpperCase()).toString();
    }

    public static String lowercaseFirstLetter(String name) {
        if (Validate.isNullOrEmpty(name)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        String c = String.valueOf(sb.charAt(0));
        return sb.replace(0, 1, c.toLowerCase()).toString();
    }

    public static List<String> splite(String regex, String content) {
        String[] array = content.split(regex);
        ArrayList<String> list = new ArrayList<String>();
        for (String temp : array) {
            if (Validate.isNullOrEmpty(temp)) continue;
            list.add(temp);
        }
        return list;
    }

    public static String getStackMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static boolean hasLength(String text) {
        return text != null && text.length() > 0;
    }

    public static boolean hasText(String str) {
        return StringUtility.hasLength(str) && StringUtility.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtility.hasLength(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(Collection<?> objs, char c) {
        return StringUtility.join(objs.toArray(), c);
    }

    public static String join(Collection<?> objs, String connector) {
        return StringUtility.join(objs.toArray(), connector);
    }

    public static String join(Object[] objs, char c) {
        return StringUtility.join(objs, String.valueOf(c));
    }

    public static String join(Object[] objs, String connector) {
        Assert.notNull(objs, "objs is null");
        Assert.state(objs.length > 0, "objs length <1");
        StringBuffer sb = new StringBuffer();
        for (Object obj : objs) {
            Assert.notNull(obj, "obj is null " + obj);
            String item = String.valueOf(obj);
            if (Validate.isNullOrEmpty(item)) continue;
            sb.append(item + connector);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static {
        String[][] arrays;
        brackets = new String[][]{{"(", ")"}, {"\uff08", "\uff09"}, {"\u3010", "\u3011"}, {"[", "]"}, {"<", ">"}};
        units = new HashMap<Character, Integer>();
        values = new HashMap<Character, Character>();
        units.put(Character.valueOf('\u96f6'), 0);
        units.put(Character.valueOf('\u767e'), 100);
        units.put(Character.valueOf('\u4f70'), 100);
        units.put(Character.valueOf('\u5341'), 10);
        units.put(Character.valueOf('\u62fe'), 10);
        units.put(Character.valueOf('\u5343'), 1000);
        units.put(Character.valueOf('\u4edf'), 1000);
        units.put(Character.valueOf('\u4e07'), 10000);
        units.put(Character.valueOf('\u842c'), 10000);
        units.put(Character.valueOf('\u4ebf'), 100000000);
        values.put(Character.valueOf('\u5757'), Character.valueOf('.'));
        values.put(Character.valueOf('\u4e24'), Character.valueOf('2'));
        values.put(Character.valueOf('\u4fe9'), Character.valueOf('2'));
        values.put(Character.valueOf('\u4e00'), Character.valueOf('1'));
        values.put(Character.valueOf('\u4e8c'), Character.valueOf('2'));
        values.put(Character.valueOf('\u4e09'), Character.valueOf('3'));
        values.put(Character.valueOf('\u56db'), Character.valueOf('4'));
        values.put(Character.valueOf('\u4e94'), Character.valueOf('5'));
        values.put(Character.valueOf('\u516d'), Character.valueOf('6'));
        values.put(Character.valueOf('\u4e03'), Character.valueOf('7'));
        values.put(Character.valueOf('\u516b'), Character.valueOf('8'));
        values.put(Character.valueOf('\u4e5d'), Character.valueOf('9'));
        values.put(Character.valueOf('\u58f9'), Character.valueOf('1'));
        values.put(Character.valueOf('\u8d30'), Character.valueOf('2'));
        values.put(Character.valueOf('\u53c1'), Character.valueOf('3'));
        values.put(Character.valueOf('\u8086'), Character.valueOf('4'));
        values.put(Character.valueOf('\u4f0d'), Character.valueOf('5'));
        values.put(Character.valueOf('\u9646'), Character.valueOf('6'));
        values.put(Character.valueOf('\u67d2'), Character.valueOf('7'));
        values.put(Character.valueOf('\u634c'), Character.valueOf('8'));
        values.put(Character.valueOf('\u7396'), Character.valueOf('9'));
        arab_format = new HashMap<Character, Character>(){
            private static final long serialVersionUID = 1L;
            {
                String[] array = new String[]{"\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19", "\u00ba\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079", "\u2080\u2081\u2082\u2083\u2084\u2085\u2086\u2087\u2088\u2089"};
                String s = "0123456789";
                for (String temp : array) {
                    for (int i = 0; i < 10; ++i) {
                        this.put(Character.valueOf(temp.charAt(i)), Character.valueOf(s.charAt(i)));
                    }
                }
            }
        };
        english_format = new HashMap<Character, Character>();
        for (String[] array : arrays = new String[][]{{"\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"}, {"\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a", "abcdefghijklmnopqrstuvwxyz"}}) {
            for (int i = 0; i < 26; ++i) {
                char c1 = array[0].charAt(i);
                char c2 = array[1].charAt(i);
                english_format.put(Character.valueOf(c1), Character.valueOf(c2));
            }
        }
    }
}

