/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.analyse.Validate;
import java.io.File;
import java.net.URL;

public class PathUtil {
    private PathUtil() {
    }

    public static String underWebContent() {
        String path = PathUtil.getClassPath();
        path = path.indexOf("WebContent") != -1 ? path.substring(0, path.indexOf("WebContent") + "WebContent".length()) + "/" : PathUtil.underCurrentProject();
        return path;
    }

    public static String under(String menu) {
        String path = PathUtil.getClassPath();
        if (path.indexOf(menu) != -1) {
            path = path.substring(0, path.indexOf(menu) + menu.length()) + "/";
        }
        return path;
    }

    public static String underSrc(String addTo) throws NullPointerException {
        try {
            String path = PathUtil.class.getResource("/" + addTo).getPath();
            return path;
        }
        catch (NullPointerException e) {
            System.out.println(PathUtil.class.getResource("/").getPath() + addTo);
            throw e;
        }
    }

    public static String getClassPath() {
        URL url = PathUtil.class.getResource("/");
        if (url == null) {
            url = PathUtil.class.getResource("");
        }
        String path = url.getPath();
        return path;
    }

    public static String underCurrentProject() {
        String path = System.getProperty("user.dir");
        if (path.contains("jar!")) {
            int index = path.indexOf("jar!");
            path = path.substring(0, index);
            index = path.lastIndexOf("/");
            path = path.substring(0, index + 1);
        }
        if (!Validate.isNullOrEmpty(path = path.contains(File.separator + "WebContent") ? path.substring(0, path.indexOf("WebContent") - 1) : (path.contains(File.separator + "WEB-INF") ? path.substring(0, path.indexOf("WEB-INF") - 1) : (path.contains(File.separator + "bin") ? path.substring(0, path.indexOf("bin") - 1) : (path.contains(File.separator + "target") ? path.substring(0, path.indexOf("target") - 1) : (path.contains(File.separator + "classes") ? path.substring(0, path.indexOf("classes") - 1) : new File("").getAbsolutePath()))))) && path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        return path;
    }

    public static String getUserHome() {
        return System.getProperty("user.home") + File.separator;
    }
}

