/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.Print;
import com.mhdt.analyse.Statistics;
import com.mhdt.analyse.Validate;
import com.mhdt.exception.SyntheticImagesException;
import com.mhdt.exception.imageTransformException;
import com.mhdt.io.IMGIO;
import com.mhdt.toolkit.FileUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageUtility {
    private ImageUtility() {
    }

    public static final BufferedImage appendString(BufferedImage bf, String content, Font font) {
        Graphics2D g = bf.createGraphics();
        g.setColor(Color.white);
        g.setFont(font);
        g.drawString(content, bf.getWidth() / 2 - content.length() * 7, 12 + (bf.getHeight() - 14) / 2);
        g.dispose();
        return bf;
    }

    public static final BufferedImage appendString(File file, String content, Font font) throws FileNotFoundException {
        BufferedImage bf = IMGIO.load(file);
        Graphics2D g = bf.createGraphics();
        g.setColor(Color.white);
        g.setFont(font);
        g.drawString(content, bf.getWidth() / 2 - content.length() * 7, 12 + (bf.getHeight() - 14) / 2);
        g.dispose();
        return bf;
    }

    public static final Collection<BufferedImage> appendString(Collection<BufferedImage> list, String content, Font font, int excursionX, int excursionY) {
        for (BufferedImage bf : list) {
            Graphics2D g = bf.createGraphics();
            g.setColor(Color.white);
            g.setFont(font);
            g.drawString(content, (bf.getWidth() - (Statistics.chineseCount(content) * font.getSize() + Statistics.blankCount(content) * 7)) / 2 + excursionX, 12 + excursionY + (bf.getHeight() - font.getSize()) / 2);
            g.dispose();
        }
        return list;
    }

    public static final Collection<BufferedImage> appendString(Collection<BufferedImage> list, String content, Font font) {
        return ImageUtility.appendString(list, content, font, 0, 0);
    }

    public static final BufferedImage gray(BufferedImage image) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, null);
        BufferedImage newPic = op.filter(image, null);
        return newPic;
    }

    public static final BufferedImage tranSparence(BufferedImage image, double alpha) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 2);
        if (alpha < 0.0) {
            alpha = 0.0;
        } else if (alpha > 1.0) {
            alpha = 1.0;
        }
        alpha = 255.0 * alpha;
        int rgb = 0;
        Color color = null;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                rgb = image.getRGB(i, j);
                if (rgb != 0) {
                    color = new Color(rgb);
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)alpha);
                    newImage.setRGB(i, j, color.getRGB());
                    continue;
                }
                newImage.setRGB(i, j, rgb);
            }
        }
        return newImage;
    }

    public static final void append(File srcFolder) {
        ImageUtility.append(srcFolder, srcFolder.getName(), true, 0);
    }

    public static final void append(File srcFolder, int cols) {
        ImageUtility.append(srcFolder, srcFolder.getName(), true, cols);
    }

    public static final void append(File srcFolder, String outPutFileName, boolean isX, int cols) {
        File[] files;
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        for (File file : files = srcFolder.listFiles()) {
            if (!file.getName().endsWith("png") && !file.getName().endsWith("jpg")) continue;
            try {
                list.add(IMGIO.load(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (cols < 1) {
            cols = list.size();
        }
        int row = 1;
        row = list.size() % cols == 0 ? list.size() / cols : list.size() / cols + 1;
        BufferedImage result = ImageUtility.append(list, isX, cols);
        File file = outPutFileName.lastIndexOf(".") == -1 || Validate.isNullOrEmpty(outPutFileName.substring(outPutFileName.lastIndexOf("."))) ? new File(FileUtility.getLastDerectory(srcFolder) + "/" + outPutFileName + "_" + row + "-" + cols + ".png") : new File(FileUtility.getLastDerectory(srcFolder) + "/" + outPutFileName + "_" + row + "-" + cols);
        if (result != null) {
            IMGIO.save(result, file);
        }
    }

    public static final BufferedImage append(List<BufferedImage> list, boolean isX, int cols) {
        if (list == null || list.isEmpty()) {
            Print.error("the image source is Null .");
            throw new NullPointerException();
        }
        try {
            boolean isFirstPng = true;
            BufferedImage outputImg = null;
            int outputImgW = 0;
            int outputImgH = 0;
            int currenW = 0;
            int currenH = 0;
            int row = 1;
            int i = 1;
            if (cols < 1) {
                cols = list.size();
            }
            row = list.size() % cols == 0 ? list.size() / cols : list.size() / cols + 1;
            for (BufferedImage image : list) {
                if (isFirstPng) {
                    isFirstPng = false;
                    outputImg = image;
                    outputImgW = outputImg.getWidth();
                    outputImgH = outputImg.getHeight();
                    ++i;
                    continue;
                }
                BufferedImage appendImg = image;
                int appendImgW = appendImg.getWidth();
                int appendImgH = appendImg.getHeight();
                if (isX) {
                    if (i <= cols) {
                        outputImgW += appendImgW;
                        outputImgH = outputImgH > appendImgH ? outputImgH : appendImgH;
                    } else if (i > row * cols) {
                        outputImgH += appendImgH;
                    }
                } else if (i <= cols) {
                    outputImgW = outputImgW > appendImgW ? outputImgW : appendImgW;
                    outputImgH += appendImgH;
                } else if (i > row * cols) {
                    outputImgW += appendImgW;
                }
                Graphics2D g2d = outputImg.createGraphics();
                BufferedImage newImage = g2d.getDeviceConfiguration().createCompatibleImage(outputImgW, outputImgH, 3);
                g2d.dispose();
                g2d = newImage.createGraphics();
                int oldImgW = outputImg.getWidth();
                int oldImgH = outputImg.getHeight();
                g2d.drawImage(outputImg, 0, 0, oldImgW, oldImgH, null);
                if (isX) {
                    if (i <= cols) {
                        g2d.drawImage(appendImg, oldImgW, 0, appendImgW, appendImgH, null);
                        ++i;
                    } else if (i > row * cols) {
                        g2d.drawImage(appendImg, 0, oldImgH, appendImgW, appendImgH, null);
                        currenW = appendImgW;
                        currenH = oldImgH;
                        ++i;
                        ++row;
                    } else {
                        g2d.drawImage(appendImg, currenW, currenH, appendImgW, appendImgH, null);
                        currenW += appendImgW;
                        ++i;
                    }
                } else if (i <= cols) {
                    g2d.drawImage(appendImg, 0, oldImgH, appendImgW, appendImgH, null);
                    ++i;
                } else if (i > row * cols) {
                    g2d.drawImage(appendImg, oldImgW, 0, appendImgW, appendImgH, null);
                    currenW = oldImgW;
                    currenH = appendImgH;
                    ++row;
                    ++i;
                } else {
                    g2d.drawImage(appendImg, currenW, currenH, appendImgW, appendImgH, null);
                    currenH += appendImgH;
                    ++i;
                }
                g2d.dispose();
                outputImg = newImage;
            }
            return outputImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final BufferedImage[][] splitTiles(BufferedImage src, int tileWidth, int tileHeight) {
        int width = src.getWidth();
        int height = src.getHeight();
        int tile_rows = height / tileHeight == 0 ? height / tileHeight : height / tileHeight + 1;
        int tile_cols = width / tileWidth == 0 ? width / tileWidth : width / tileWidth + 1;
        BufferedImage[][] results = new BufferedImage[tile_rows][tile_cols];
        for (int row = 0; row < tile_rows; ++row) {
            for (int col = 0; col < tile_cols; ++col) {
                int temp_width = tileWidth;
                int temp_height = tileHeight;
                if (row == tile_rows - 1) {
                    temp_height = height % tileHeight;
                }
                if (col == tile_cols - 1) {
                    temp_width = width % tileWidth;
                }
                BufferedImage temp = new BufferedImage(temp_width, temp_height, 8);
                Graphics2D g2d = temp.createGraphics();
                g2d.drawImage((Image)src.getSubimage(col * tileWidth, row * tileHeight, temp_width, temp_height), 0, 0, null);
                g2d.dispose();
                results[row][col] = temp;
            }
        }
        return results;
    }

    public static final List<List<BufferedImage>> splitByRows(File file) throws SyntheticImagesException, FileNotFoundException {
        ArrayList<List<BufferedImage>> list = new ArrayList<List<BufferedImage>>();
        int[] array = ImageUtility.getRowsAndCols(file.getName());
        int rows = array[0];
        int cols = array[1];
        BufferedImage image = IMGIO.load(file);
        int width = image.getWidth() / cols;
        int height = image.getHeight() / rows;
        for (int row = 0; row < rows; ++row) {
            ArrayList<BufferedImage> temp = new ArrayList<BufferedImage>();
            for (int col = 0; col < cols; ++col) {
                int[] rgb = new int[width * height];
                image.getRGB(col * width, row * height, width, height, rgb, 0, width);
                BufferedImage newImage = new BufferedImage(width, height, 2);
                newImage.setRGB(0, 0, width, height, rgb, 0, width);
                temp.add(newImage);
            }
            list.add(temp);
        }
        return list;
    }

    public static final List<BufferedImage> split(File file) throws SyntheticImagesException, FileNotFoundException {
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        int[] array = ImageUtility.getRowsAndCols(file.getName());
        if (array == null) {
            list.add(IMGIO.load(file));
            return list;
        }
        int rows = array[0];
        int cols = array[1];
        BufferedImage image = IMGIO.load(file);
        int width = image.getWidth() / cols;
        int height = image.getHeight() / rows;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int[] rgb = new int[width * height];
                image.getRGB(col * width, row * height, width, height, rgb, 0, width);
                BufferedImage newImage = null;
                try {
                    newImage = new BufferedImage(width, height, 2);
                }
                catch (Exception e) {
                    System.out.println(file.getName());
                    e.printStackTrace();
                }
                newImage.setRGB(0, 0, width, height, rgb, 0, width);
                list.add(newImage);
            }
        }
        return list;
    }

    private static final int[] getRowsAndCols(String name) throws SyntheticImagesException {
        if (name.indexOf("_") == -1 || name.indexOf("-") == -1) {
            throw new SyntheticImagesException("\u3010ERROR\u3011 \u56fe\u7247\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5 " + name + "\uff0c\u8bf7\u4f7f\u7528\u4f8b\u5982: test_row(\u6570\u5b57\u4ee3\u8868\u884c\u6570)-col(\u6570\u5b57\u4ee3\u8868\u5217\u6570).png \u6765\u547d\u540d\u4f60\u7684\u56fe\u7247\u5408\u6210\u6587\u4ef6");
        }
        int[] ary = new int[2];
        String[] array = name.substring(name.lastIndexOf("_") + 1).split("\\.")[0].split("-");
        try {
            ary[0] = Integer.parseInt(array[0]);
            ary[1] = Integer.parseInt(array[1]);
        }
        catch (NumberFormatException e) {
            throw new SyntheticImagesException("\u3010ERROR\u3011 \u56fe\u7247\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5 " + name + "\uff0c\u8bf7\u4f7f\u7528\u4f8b\u5982: test_row(\u6570\u5b57\u4ee3\u8868\u884c\u6570)-col(\u6570\u5b57\u4ee3\u8868\u5217\u6570).png(\u53ca\u5176\u5b83\u53ef\u89e3\u6790\u6587\u4ef6\u540e\u7f00) \u6765\u547d\u540d\u4f60\u7684\u56fe\u7247\u5408\u6210\u6587\u4ef6");
        }
        return ary;
    }

    public static BufferedImage clip(BufferedImage bufferedImage, int startX, int startY, int width, int height) {
        BufferedImage newImage = new BufferedImage(width, height, 2);
        int[] rgb = new int[width * height];
        bufferedImage.getRGB(startX, startY, width, height, rgb, 0, width);
        newImage.setRGB(0, 0, width, height, rgb, 0, width);
        return newImage;
    }

    public static Image scaleImage(BufferedImage src, float scale) {
        return ImageUtility.scaleImage(src, (int)((float)src.getWidth() * scale), (int)((float)src.getHeight() * scale));
    }

    public static Image scaleImage(BufferedImage src, int newWidth, int newHeight) {
        return ImageUtility.scaleImage(src, newWidth, newHeight, 4);
    }

    public static Image scaleImage(BufferedImage src, int newWidth, int newHeight, int imageArithmetic) {
        return src.getScaledInstance(newWidth, newHeight, imageArithmetic);
    }

    public static BufferedImage imageToBufferedImage(Image src, int bufferedType) throws imageTransformException {
        if (src instanceof BufferedImage) {
            return (BufferedImage)src;
        }
        int width = src.getWidth(null);
        int height = src.getHeight(null);
        if (!(src instanceof BufferedImage) && width == -1 && height == -1) {
            throw new imageTransformException("SRC-image cant cast to BufferedImage,\nbecause width=-1 and height==-1  try IMGIO.load image use ImageUtily.IMGIO.load(...)");
        }
        BufferedImage bf = new BufferedImage(width, height, bufferedType);
        Graphics g2d = bf.getGraphics();
        g2d.drawImage(src, 0, 0, width, height, null);
        g2d.dispose();
        return bf;
    }

    public static Image bufferedImageToImage(BufferedImage src) {
        return ImageUtility.scaleImage(src, 1.0f);
    }

    public static BufferedImage hightLight(BufferedImage image, int value) {
        BufferedImage bf = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                if (rgb == 0 || rgb == 4494294) continue;
                Color color = new Color(rgb);
                int r = color.getRed() + value;
                int g = color.getGreen() + value;
                int b = color.getBlue() + value;
                if (r > 255) {
                    r = 255;
                } else if (r < 0) {
                    r = 0;
                }
                if (g > 255) {
                    g = 255;
                } else if (g < 0) {
                    g = 0;
                }
                if (b > 255) {
                    b = 255;
                } else if (b < 0) {
                    b = 0;
                }
                color = new Color(r, g, b);
                bf.setRGB(x, y, color.getRGB());
            }
        }
        return bf;
    }

    public static BufferedImage rotate(Image src, int angel) {
        int src_width = src.getWidth(null);
        int src_height = src.getHeight(null);
        Rectangle rect_des = ImageUtility.CalcRotatedSize(new Rectangle(new Dimension(src_width, src_height)), angel);
        BufferedImage destImage = null;
        destImage = new BufferedImage(rect_des.width, rect_des.height, 2);
        Graphics2D g2 = destImage.createGraphics();
        g2.translate((rect_des.width - src_width) / 2, (rect_des.height - src_height) / 2);
        g2.rotate(Math.toRadians(angel), src_width / 2, src_height / 2);
        g2.drawImage(src, null, null);
        return destImage;
    }

    private static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }
}

