/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.io.FileIO;
import com.mhdt.log.LogOut;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ExceptionPrintStream
extends PrintStream {
    static List<LogOut> listLogOut = new ArrayList<LogOut>();

    private ExceptionPrintStream() {
        super(System.err);
    }

    static ExceptionPrintStream getInstance() {
        return LazyLogPrintStream.logPrintStream;
    }

    public static void addLogOut(LogOut logOut) {
        if (!listLogOut.contains(logOut)) {
            listLogOut.add(logOut);
        }
    }

    @Override
    public void print(String s) {
        HashSet<String> files = new HashSet<String>();
        for (LogOut item : listLogOut) {
            File file = item.getErrorFile();
            if (file == null || files.contains(file.getAbsolutePath())) continue;
            files.add(file.getAbsolutePath());
            long now = System.currentTimeMillis();
            if (now - item.getLastTime() > 1100L) {
                if (file.length() != 0L) {
                    FileIO.write(file, "\r\n-----------------------------------------------------------------------------------\r\n\r\n", true);
                }
                String content = s + "\r\n";
                FileIO.write(file, content, true);
                item.setLastTime(now);
                continue;
            }
            FileIO.write(file, s + "\r\n", true);
        }
        super.print(s);
    }

    private static class LazyLogPrintStream {
        static ExceptionPrintStream logPrintStream = new ExceptionPrintStream();

        private LazyLogPrintStream() {
        }
    }
}

