/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.io;

import com.mhdt.toolkit.FileUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;

public class FileIO {
    private FileIO() {
    }

    public static String getContent(InputStream in) {
        return FileIO.getContent(in, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(InputStream in, String encode) {
        InputStreamReader isr = null;
        BufferedReader bf = null;
        try {
            isr = new InputStreamReader(in, encode);
            bf = new BufferedReader(isr);
            String string = FileIO.getContent(bf);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bf.close();
                isr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String getContent(File file) {
        return FileIO.getContent(file, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File file, String encode) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader bf = null;
        try {
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, encode);
            bf = new BufferedReader(isr);
            String string = FileIO.getContent(bf);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bf.close();
                isr.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String getContent(String path) throws FileNotFoundException {
        return FileIO.getContent(path, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String path, String encode) throws FileNotFoundException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader bf = null;
        try {
            fis = new FileInputStream(path);
            isr = new InputStreamReader((InputStream)fis, encode);
            bf = new BufferedReader(isr);
            String string = FileIO.getContent(bf);
            return string;
        }
        catch (FileNotFoundException e1) {
            throw e1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private static String getContent(BufferedReader br) throws IOException {
        StringBuffer sb = new StringBuffer();
        String s = null;
        while ((s = br.readLine()) != null) {
            sb.append(s + "\r\n");
        }
        return sb.length() > 0 ? sb.toString().substring(0, sb.toString().lastIndexOf("\r\n")) : "";
    }

    public static void write(File file, String conent, boolean isAppend) {
        FileIO.write(file, conent, isAppend, "utf-8");
    }

    public static void write(File file, Collection<String> content, boolean isAppend) {
        StringBuilder sb = new StringBuilder();
        for (String s : content) {
            sb.append(s + "\r\n");
        }
        FileIO.write(file, sb.toString(), isAppend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String conent, boolean isAppend, String encode) {
        FileUtility.createFile(file);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, isAppend), encode));
            out.write(conent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeArray(File file, Object[][] array) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter write = null;
        try {
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter(fos);
            write = new BufferedWriter(osw);
            for (int row = 0; row < array.length; ++row) {
                for (int col = 0; col < array[row].length; ++col) {
                    write.write(array[row][col] + "");
                }
                write.write("\r\n");
            }
            write.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
                osw.close();
                write.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readArray(File file) {
        int[][] array = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader read = null;
        try {
            fis = new FileInputStream(file);
            isr = new InputStreamReader(fis);
            read = new BufferedReader(isr);
            String s = null;
            ArrayList<String> list = new ArrayList<String>();
            while ((s = read.readLine()) != null) {
                list.add(s);
            }
            array = new int[list.size()][((String)list.get(0)).length()];
            for (int row = 0; row < list.size(); ++row) {
                char[] chars = ((String)list.get(row)).toCharArray();
                for (int col = 0; col < chars.length; ++col) {
                    array[row][col] = chars[col] - 48;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
                isr.close();
                read.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return array;
    }

    public static void writeObject(Object object, File outFile) {
        FileIO.writeObject(object, outFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object object, File outFile, boolean append) {
        FileUtility.createFile(outFile);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(outFile, append);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                oos.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File fromFile) {
        Object object = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(fromFile);
            ois = new ObjectInputStream(fis);
            object = ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
                ois.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static byte[] read(File file) {
        byte[] data = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            data = new byte[in.available()];
            in.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(File file, byte[] bytes, boolean append) {
        FileUtility.createFile(file);
        if (bytes == null || bytes.length < 1) {
            return false;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file, append));){
            out.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

