/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mhdt.analyse.Validate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RequestResult {
    String status;
    String message;
    Map<String, Object> data = new HashMap<String, Object>();
    String jsonData;

    private RequestResult() {
    }

    public static RequestResult success() {
        return RequestResult.status(Status.SUCCESS);
    }

    public static RequestResult faild() {
        return RequestResult.status(Status.FAILD);
    }

    public RequestResult faild(String message) {
        this.status = Status.FAILD.getValue();
        this.message(message);
        return this;
    }

    public RequestResult faild(Throwable throwable) {
        this.status = Status.FAILD.value;
        return this.message(throwable.getMessage());
    }

    public static RequestResult status(Status status) {
        RequestResult result = new RequestResult();
        result.status = status.value;
        return result;
    }

    public RequestResult message(String message) {
        this.message = message;
        return this;
    }

    public RequestResult putAttribute(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public Object getAttribute(String key) {
        return this.data.get(key);
    }

    public String getStringFromJson(String key) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return null;
        }
        return JSON.parseObject((String)this.jsonData).getString(key);
    }

    public Integer getIntFromJson(String key) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return null;
        }
        return JSON.parseObject((String)this.jsonData).getIntValue(key);
    }

    public <T> T getObjectFromJson(String key, Class<T> cls) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return null;
        }
        return (T)JSON.parseObject((String)JSON.parseObject((String)this.jsonData).getString(key), cls);
    }

    public <T> List<T> getListFromJson(String key, Class<T> cls) {
        if (this.jsonData == null || Validate.isNullOrEmpty(JSON.parseObject((String)this.jsonData).getString(key))) {
            return new ArrayList();
        }
        ArrayList list = JSON.parseArray((String)JSON.parseObject((String)this.jsonData).getString(key), cls);
        if (list.size() == 1 && list.get(0) == null) {
            list = new ArrayList();
        }
        return list;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static RequestResult parse(byte[] bytes) {
        RequestResult requestResult = new RequestResult();
        JSONObject object = JSON.parseObject((String)new String(bytes));
        requestResult.status = object.getString("status");
        requestResult.message = object.getString("message");
        requestResult.jsonData = object.getString("data");
        return requestResult;
    }

    public static RequestResult perform(Consumer<RequestResult> consumer) {
        RequestResult result = new RequestResult();
        try {
            result.status = Status.SUCCESS.value;
            consumer.accept(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.status = Status.FAILD.value;
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public void putAttribute(Map<String, Object> atttibuters) {
        this.data.putAll(atttibuters);
    }

    public static enum Status {
        SUCCESS("success"),
        FAILD("faild");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

