/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.analyse.Validate;
import com.mhdt.log.AbstractLog;
import com.mhdt.log.Log;
import com.mhdt.toolkit.DateUtility;
import com.mhdt.toolkit.FileUtility;
import com.mhdt.toolkit.StringUtility;
import java.io.File;

public class IndependentLog
extends AbstractLog {
    String namespace;
    File outputFolder = new File(Log.DEFAULTOUTPATH);

    public IndependentLog(String namespace) {
        this.namespace = namespace;
    }

    @Override
    protected String generatingOutput(Log.Level level, String methodName, Object message, Throwable throwable) {
        return DateUtility.getNow("z M, y HH:mm:ss a") + " " + this.namespace + " " + methodName + "\r\n" + level.sign + ": " + (message == null ? "\tnull" : message.toString()) + " " + StringUtility.getStackMessage(throwable);
    }

    public IndependentLog(String namespace, File outputFolder) {
        if (outputFolder == null) {
            throw new NullPointerException("\u8f93\u51fa\u6587\u4ef6\u5939\u4e3anull");
        }
        if (Validate.isNullOrEmpty(namespace)) {
            throw new NullPointerException("\u547d\u540d\u7a7a\u95f4\u4e3a\u7a7a");
        }
        if (!outputFolder.exists()) {
            FileUtility.createFloder(outputFolder);
        }
        this.namespace = namespace;
    }

    @Override
    public File getLogFile() {
        File file = FileUtility.join(this.outputFolder, DateUtility.getNow("YYYYMMdd") + ".txt");
        if (!file.exists()) {
            FileUtility.createFile(file);
        }
        return file;
    }

    @Override
    public File getErrorFile() {
        return this.getLogFile();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }
}

